/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.network.configuration;

import com.ubnt.data.X;
import com.ubnt.model.api.network.configuration.WanDhcpV6Option;
import com.ubnt.model.api.network.configuration.WanDhcpV6OptionType;
import com.ubnt.service.network.configuration.B.$A;
import com.ubnt.service.network.configuration.B.FA;
import com.ubnt.service.network.configuration.B.R;
import com.ubnt.service.network.configuration.B.StringObject;
import com.ubnt.service.network.configuration.B.ifnew;
import com.ubnt.service.network.configuration.B.oO00;
import com.ubnt.udapi.oo00;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public record WanDhcpV6OptionConfiguration(WanDhcpV6Option option, String value) {
    private static final Pattern DUID_PATTERN = Pattern.compile("^([0-9a-fA-F]{2}:){2,129}[0-9a-fA-F]{2}$");
    private static final int HEADER_LEN_AUTHENTICATION = 3;
    private static final int REPLAY_LEN_AUTHENTICATION = 8;
    private static final int HMAC_LEN_AUTHENTICATION = 16;
    private static final int MIN_LENGTH_AUTHENTICATION = 27;
    private static final WanDhcpV6OptionConfiguration EMPTY = new WanDhcpV6OptionConfiguration(null, "");

    public static WanDhcpV6OptionConfiguration fromLegacy(X x2) {
        WanDhcpV6Option wanDhcpV6Option = x2.getOptionalInt("optionNumber").flatMap(WanDhcpV6Option::ofOptionalNumber).orElse(null);
        if (wanDhcpV6Option == null) {
            return EMPTY;
        }
        String string = x2.getOptionalString("value").orElse("");
        return new WanDhcpV6OptionConfiguration(wanDhcpV6Option, string);
    }

    public static List<oo00> toUdapiDhcpOptions(List<WanDhcpV6OptionConfiguration> list) {
        return list.stream().map(WanDhcpV6OptionConfiguration::toUdapiDhcpOption).flatMap(Optional::stream).toList();
    }

    public static Optional<String> extractDuidFromOptions(List<WanDhcpV6OptionConfiguration> list) {
        return list.stream().map(WanDhcpV6OptionConfiguration::getDuidOptional).flatMap(Optional::stream).findFirst();
    }

    public Optional<String> getDuidOptional() {
        return this.option == WanDhcpV6Option.OPTION_1 ? Optional.of(this.value) : Optional.empty();
    }

    public Optional<oo00> toUdapiDhcpOption() {
        return this.option == WanDhcpV6Option.OPTION_1 ? Optional.empty() : Optional.of(new oo00(this.option.getOptionNumber(), this.value));
    }

    public void validate() {
        if (this.option == null) {
            throw new StringObject();
        }
        switch (this.option) {
            case OPTION_1: {
                this.\u00d500000(this.value);
                break;
            }
            case OPTION_11: {
                this.new(this.value);
                break;
            }
            case OPTION_16: {
                this.\u00d400000(this.value);
                break;
            }
            default: {
                this.o00000(this);
            }
        }
    }

    private void \u00d500000(String string) {
        if (string == null || !DUID_PATTERN.matcher(string).matches()) {
            throw new $A(string);
        }
    }

    private void new(String string) {
        byte[] byArray = this.\u00d300000(string);
        if (byArray.length < 27) {
            throw new FA(11, 27);
        }
    }

    private void \u00d400000(String string) {
        byte[] byArray = this.\u00d300000(string);
        if (byArray.length == 0) {
            throw new oO00(16);
        }
    }

    private byte[] \u00d300000(String string) {
        try {
            return Hex.decodeHex((String)string);
        }
        catch (DecoderException decoderException) {
            return new byte[0];
        }
    }

    private void o00000(WanDhcpV6OptionConfiguration wanDhcpV6OptionConfiguration) {
        if (wanDhcpV6OptionConfiguration.option.getType() == WanDhcpV6OptionType.OPTION_VALUE_CARRYING) {
            if (StringUtils.isBlank((CharSequence)wanDhcpV6OptionConfiguration.value)) {
                throw new R(wanDhcpV6OptionConfiguration.option.getOptionNumber());
            }
        } else if (wanDhcpV6OptionConfiguration.option.getType() == WanDhcpV6OptionType.OPTION_REQUESTABLE && StringUtils.isNotEmpty((CharSequence)wanDhcpV6OptionConfiguration.value)) {
            throw new ifnew(wanDhcpV6OptionConfiguration.option.getOptionNumber());
        }
    }
}

