/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.view.swing.map.outline.TreeNode;

class VisibleOutlineNodes {
    private final TreeNode root;
    private List<TreeNode> visibleNodes = new ArrayList<TreeNode>();
    private final Map<String, Integer> indexById = new HashMap<String, Integer>();
    private int breadcrumbHeight = 0;
    private int blockPanelY = 0;
    private TreeNode hoveredNode;
    private String firstVisibleNodeId;
    private boolean isHoveredNodeContainedInBreadcrumb;

    VisibleOutlineNodes(TreeNode root) {
        this.root = root;
        this.hoveredNode = null;
        this.updateVisibleNodes();
    }

    void updateVisibleNodes() {
        this.visibleNodes.clear();
        this.indexById.clear();
        this.buildVisibleList(this.root);
        for (int i = 0; i < this.visibleNodes.size(); ++i) {
            TreeNode n = this.visibleNodes.get(i);
            if (n == null) continue;
            this.indexById.put(n.getId(), i);
        }
    }

    private void buildVisibleList(TreeNode node) {
        this.visibleNodes.add(node);
        if (node.isExpanded()) {
            for (TreeNode child : node.getChildren()) {
                this.buildVisibleList(child);
            }
        }
    }

    int getVisibleNodeCount() {
        return this.visibleNodes.size();
    }

    String getFirstVisibleNodeId() {
        return this.firstVisibleNodeId;
    }

    void setFirstVisibleNodeId(String id) {
        this.firstVisibleNodeId = id;
    }

    int findNodeIndexById(String id) {
        if (id == null) {
            return -1;
        }
        Integer idx = this.indexById.get(id);
        return idx != null ? idx : -1;
    }

    int findNodeIndexInVisibleList(TreeNode node) {
        if (node == null) {
            return -1;
        }
        Integer idx = this.indexById.get(node.getId());
        return idx != null ? idx : -1;
    }

    TreeNode findNodeById(String id) {
        int index = this.findNodeIndexById(id);
        return this.getNodeAtVisibleIndex(index);
    }

    int getBreadcrumbHeight() {
        return this.breadcrumbHeight;
    }

    void setBreadcrumbHeight(int height) {
        this.breadcrumbHeight = height;
    }

    int getBlockPanelY() {
        return this.blockPanelY;
    }

    void setBlockPanelY(int blockPanelY) {
        this.blockPanelY = blockPanelY;
    }

    TreeNode getHoveredNode() {
        return this.hoveredNode;
    }

    void setHoveredNode(TreeNode node, boolean isBreadcrumb) {
        this.hoveredNode = node;
        this.isHoveredNodeContainedInBreadcrumb = isBreadcrumb;
    }

    void setHoveredNode(TreeNode node) {
        this.hoveredNode = node;
    }

    boolean isHoveredNodeContainedInBreadcrumb() {
        return this.isHoveredNodeContainedInBreadcrumb;
    }

    TreeNode getNodeAtVisibleIndex(int index) {
        if (index < 0 || index >= this.visibleNodes.size()) {
            return null;
        }
        return this.visibleNodes.get(index);
    }

    String getNodeIdAtVisibleIndex(int index) {
        TreeNode f = this.getNodeAtVisibleIndex(index);
        return f != null ? f.getId() : null;
    }
}

