/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.actions.Editable;
import org.netbeans.swing.laf.flatlaf.FlatLafOptionsPanelController;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FlatLafOptionsPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(FlatLafOptionsPanel.class);
    private final FlatLafOptionsPanelController controller;
    private JPanel advPanel;
    private JCheckBox alwaysShowMnemonicsCheckBox;
    private JButton customPropertiesButton;
    private JLabel customPropertiesLabel;
    private JCheckBox menuBarEmbeddedCheckBox;
    private JCheckBox underlineMenuSelectionCheckBox;
    private JCheckBox unifiedTitleBarCheckBox;
    private JCheckBox useWindowDecorationsCheckBox;

    public FlatLafOptionsPanel(FlatLafOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean supportsWindowDecorations = FlatLaf.supportsNativeWindowDecorations();
        this.useWindowDecorationsCheckBox.setEnabled(supportsWindowDecorations);
        this.unifiedTitleBarCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.menuBarEmbeddedCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.underlineMenuSelectionCheckBox.setEnabled(!SystemInfo.isMacOS);
    }

    private void initComponents() {
        this.useWindowDecorationsCheckBox = new JCheckBox();
        this.menuBarEmbeddedCheckBox = new JCheckBox();
        this.unifiedTitleBarCheckBox = new JCheckBox();
        this.underlineMenuSelectionCheckBox = new JCheckBox();
        this.alwaysShowMnemonicsCheckBox = new JCheckBox();
        this.advPanel = new JPanel();
        this.customPropertiesLabel = new JLabel();
        this.customPropertiesButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Mnemonics.setLocalizedText((AbstractButton)this.useWindowDecorationsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.useWindowDecorationsCheckBox.text"));
        this.useWindowDecorationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.useWindowDecorationsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.menuBarEmbeddedCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.menuBarEmbeddedCheckBox.text"));
        this.menuBarEmbeddedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.menuBarEmbeddedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unifiedTitleBarCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.unifiedTitleBarCheckBox.text"));
        this.unifiedTitleBarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.unifiedTitleBarCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.underlineMenuSelectionCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.underlineMenuSelectionCheckBox.text"));
        this.underlineMenuSelectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.underlineMenuSelectionCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.alwaysShowMnemonicsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.alwaysShowMnemonicsCheckBox.text"));
        this.alwaysShowMnemonicsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.alwaysShowMnemonicsCheckBoxActionPerformed(evt);
            }
        });
        this.advPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.Advanced.title")));
        Mnemonics.setLocalizedText((JLabel)this.customPropertiesLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.customPropertiesButton, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesButton.text"));
        this.customPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.customPropertiesButtonActionPerformed(evt);
            }
        });
        GroupLayout advPanelLayout = new GroupLayout(this.advPanel);
        this.advPanel.setLayout(advPanelLayout);
        advPanelLayout.setHorizontalGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advPanelLayout.createSequentialGroup().addContainerGap().addGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPropertiesLabel).addComponent(this.customPropertiesButton)).addContainerGap(-1, Short.MAX_VALUE)));
        advPanelLayout.setVerticalGroup(advPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advPanelLayout.createSequentialGroup().addComponent(this.customPropertiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customPropertiesButton).addGap(0, 54, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useWindowDecorationsCheckBox).addComponent(this.unifiedTitleBarCheckBox).addComponent(this.menuBarEmbeddedCheckBox).addComponent(this.underlineMenuSelectionCheckBox).addComponent(this.alwaysShowMnemonicsCheckBox)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.advPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.useWindowDecorationsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unifiedTitleBarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuBarEmbeddedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.underlineMenuSelectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alwaysShowMnemonicsCheckBox).addGap(18, 18, 18).addComponent(this.advPanel, -2, -1, -2).addContainerGap()));
    }

    private void useWindowDecorationsCheckBoxActionPerformed(ActionEvent evt) {
        this.updateEnabled();
        this.fireChanged();
    }

    private void unifiedTitleBarCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void menuBarEmbeddedCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void underlineMenuSelectionCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void alwaysShowMnemonicsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void customPropertiesButtonActionPerformed(ActionEvent evt) {
        RP.execute(() -> {
            try {
                FileObject lafFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"LookAndFeel");
                FileObject customProp = lafFolder.getFileObject("FlatLaf.properties");
                if (customProp == null) {
                    customProp = lafFolder.createData("FlatLaf.properties");
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(customProp.getOutputStream()));){
                        writer.append(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customProperties.content"));
                    }
                }
                DataObject dob = DataObject.find((FileObject)customProp);
                Editable editable = (Editable)dob.getLookup().lookup(Editable.class);
                editable.edit();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private void fireChanged() {
        boolean isChanged = false;
        if (this.useWindowDecorationsCheckBox.isSelected() != FlatLafPrefs.isUseWindowDecorations() || this.unifiedTitleBarCheckBox.isSelected() != FlatLafPrefs.isUnifiedTitleBar() || this.menuBarEmbeddedCheckBox.isSelected() != FlatLafPrefs.isMenuBarEmbedded() || this.underlineMenuSelectionCheckBox.isSelected() != FlatLafPrefs.isUnderlineMenuSelection() || this.alwaysShowMnemonicsCheckBox.isSelected() != FlatLafPrefs.isAlwaysShowMnemonics()) {
            isChanged = true;
        }
        this.controller.changed(isChanged);
    }

    protected void load() {
        this.useWindowDecorationsCheckBox.setSelected(FlatLafPrefs.isUseWindowDecorations());
        this.unifiedTitleBarCheckBox.setSelected(FlatLafPrefs.isUnifiedTitleBar());
        this.menuBarEmbeddedCheckBox.setSelected(FlatLafPrefs.isMenuBarEmbedded());
        this.underlineMenuSelectionCheckBox.setSelected(FlatLafPrefs.isUnderlineMenuSelection());
        this.alwaysShowMnemonicsCheckBox.setSelected(FlatLafPrefs.isAlwaysShowMnemonics());
        this.updateEnabled();
    }

    protected boolean store() {
        FlatLafPrefs.setUseWindowDecorations(this.useWindowDecorationsCheckBox.isSelected());
        FlatLafPrefs.setUnifiedTitleBar(this.unifiedTitleBarCheckBox.isSelected());
        FlatLafPrefs.setMenuBarEmbedded(this.menuBarEmbeddedCheckBox.isSelected());
        FlatLafPrefs.setUnderlineMenuSelection(this.underlineMenuSelectionCheckBox.isSelected());
        FlatLafPrefs.setAlwaysShowMnemonics(this.alwaysShowMnemonicsCheckBox.isSelected());
        return false;
    }

    boolean valid() {
        return true;
    }
}

