/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.trace.database.listing.AbstractDBTraceDataComponent;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDefinedDataAdapter;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.util.TraceAddressSpace;

public class DBTraceDataCompositeFieldComponent
extends AbstractDBTraceDataComponent {
    protected final DataTypeComponent dtc;

    public DBTraceDataCompositeFieldComponent(DBTraceData root, DBTraceDefinedDataAdapter parent, Address address, DataTypeComponent dtc) {
        super(root, parent, dtc.getOrdinal(), address, dtc.getDataType(), dtc.getLength());
        this.dtc = dtc;
    }

    @Override
    public TraceAddressSpace getTraceSpace() {
        return this.parent.getTraceSpace();
    }

    public String getFieldName() {
        String fieldName = this.dtc.getFieldName();
        if (fieldName == null || fieldName.length() == 0) {
            return this.dtc.getDefaultFieldName();
        }
        return fieldName;
    }

    @Override
    public String getFieldSyntax() {
        return "." + this.getFieldName();
    }

    @Override
    public AddressRange getRange() {
        return new AddressRangeImpl(this.getMinAddress(), this.getMaxAddress());
    }

    @Override
    public TraceAddressSnapRange getBounds() {
        return new ImmutableTraceAddressSnapRange(this.getMinAddress(), this.getMaxAddress(), this.getLifespan());
    }
}

