/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.pattern.CombinePattern;
import ghidra.app.plugin.processors.sleigh.pattern.ContextPattern;
import ghidra.app.plugin.processors.sleigh.pattern.InstructionPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public abstract class DisjointPattern
extends Pattern {
    public abstract PatternBlock getBlock(boolean var1);

    public PatternBlock getInstructionBlock() {
        return this.getBlock(false);
    }

    public PatternBlock getContextBlock() {
        return this.getBlock(true);
    }

    public byte[] getWholeInstructionBytes() {
        return this.getInstructionBlock().getWholeBytes();
    }

    @Override
    public int numDisjoint() {
        return 0;
    }

    @Override
    public DisjointPattern getDisjoint(int i) {
        return null;
    }

    public int getMask(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getMask(startbit, size);
        }
        return 0;
    }

    public int getValue(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getValue(startbit, size);
        }
        return 0;
    }

    public int getLength(boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getLength();
        }
        return 0;
    }

    public boolean specializes(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        return true;
    }

    public boolean identical(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.identical(b)) {
                return false;
            }
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.identical(b)) {
                return false;
            }
        }
        return true;
    }

    public static DisjointPattern decodeDisjoint(Decoder decoder) throws DecoderException {
        int el = decoder.peekElement();
        DisjointPattern res = el == SlaFormat.ELEM_INSTRUCT_PAT.id() ? new InstructionPattern() : (el == SlaFormat.ELEM_CONTEXT_PAT.id() ? new ContextPattern() : new CombinePattern());
        ((Pattern)res).decode(decoder);
        return res;
    }
}

