/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

public class MissingBuiltInDataType
extends DataTypeImpl
implements Dynamic {
    private String missingBuiltInClassPath;
    private String missingBuiltInName;

    public MissingBuiltInDataType(CategoryPath path, String missingBuiltInName, String missingBuiltInClassPath, DataTypeManager dtm) {
        super(path == null ? CategoryPath.ROOT : path, "-MISSING-" + missingBuiltInName, null, BuiltInSourceArchive.INSTANCE, 0L, 0L, dtm);
        this.missingBuiltInName = missingBuiltInName;
        this.missingBuiltInClassPath = missingBuiltInClassPath;
    }

    protected void setCategory() {
    }

    public String getMissingBuiltInName() {
        return this.missingBuiltInName;
    }

    public String getMissingBuiltInClassPath() {
        return this.missingBuiltInClassPath;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getName();
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public boolean canSpecifyLength() {
        return true;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        return -1;
    }

    @Override
    public String getDescription() {
        return "Missing Built-In Data Type: " + this.missingBuiltInClassPath;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.missingBuiltInClassPath;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.missingBuiltInClassPath;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MissingBuiltInDataType(this.categoryPath, this.missingBuiltInName, this.missingBuiltInClassPath, dtm);
    }

    @Override
    public final DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (dt == this) {
            return true;
        }
        if (!(dt instanceof MissingBuiltInDataType)) {
            return false;
        }
        return this.missingBuiltInClassPath.equals(((MissingBuiltInDataType)dt).missingBuiltInClassPath);
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public void setName(String name) throws InvalidNameException {
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return null;
    }

    @Override
    public DataType getReplacementBaseType() {
        return null;
    }

    @Override
    public void setDefaultSettings(Settings settings) {
    }
}

