/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.awt.Color;
import java.util.Comparator;

public class ColorUtils {
    private static final int MAX_COLOR_VALUE = 255;
    private static final int MID_COLOR_VALUE = 127;
    private static final int MAX_NUDGE = 32;
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 0.083333336f;
    public static final float HUE_YELLOW = 0.16666667f;
    public static final float HUE_LIME = 0.25f;
    public static final float HUE_GREEN = 0.33333334f;
    public static final float HUE_PINE = 0.41666666f;
    public static final float HUE_TURQUISE = 0.5f;
    public static final float HUE_SAPPHIRE = 0.5833333f;
    public static final float HUE_BLUE = 0.6666667f;
    public static final float HUE_ROYAL = 0.75f;
    public static final float HUE_PURPLE = 0.8333333f;
    public static final float HUE_PINK = 0.9166667f;
    public static Comparator<Color> COMPARATOR = new Comparator<Color>(){

        @Override
        public int compare(Color c1, Color c2) {
            int alpha2;
            int alpha1 = c1.getAlpha();
            if (alpha1 == (alpha2 = c2.getAlpha())) {
                return this.getHsbCompareValue(c1) - this.getHsbCompareValue(c2);
            }
            return alpha1 - alpha2;
        }

        private int getHsbCompareValue(Color v) {
            float[] hsb = Color.RGBtoHSB(v.getRed(), v.getGreen(), v.getBlue(), null);
            return 100 * (int)(10.0f * hsb[0]) + 10 * (int)(10.0f * hsb[1]) + (int)(10.0f * hsb[2]);
        }
    };

    public static Color deriveBackground(Color src, float hue, float sfact, float bfact) {
        float[] vals = new float[3];
        Color.RGBtoHSB(src.getRed(), src.getGreen(), src.getBlue(), vals);
        vals[0] = hue;
        vals[1] = vals[1] * sfact;
        vals[2] = 0.5f + (vals[2] - 0.5f) * bfact;
        return Color.getHSBColor(vals[0], vals[1], vals[2]);
    }

    public static Color deriveBackground(Color background, float hue) {
        return ColorUtils.deriveBackground(background, hue, 1.0f, 0.9f);
    }

    public static Color deriveForeground(Color bg, float hue, float brt) {
        float[] vals = new float[3];
        Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), vals);
        double bx = Math.cos((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        double by = Math.sin((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        vals[0] = hue;
        vals[1] = 1.0f - vals[1];
        double fx = Math.cos((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        double fy = Math.sin((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        float hsdist = (float)Math.sqrt((bx - fx) * (bx - fx) + (by - fy) * (by - fy));
        float bdiff = 1.0f - hsdist;
        if (Math.abs(vals[2] - brt) < bdiff) {
            if (brt > vals[2]) {
                brt = vals[2] + bdiff;
                if ((double)brt > 1.0) {
                    brt -= 2.0f * bdiff;
                }
            } else {
                brt = vals[2] - bdiff;
                if ((double)brt < 0.0) {
                    brt += 2.0f * bdiff;
                }
            }
            if ((double)brt < 0.0 || (double)brt > 1.0) {
                brt = (double)vals[2] < 0.7 ? 1.0f : 0.0f;
            }
        }
        vals[2] = brt;
        for (int i = 0; i < 3; ++i) {
            vals[i] = Math.min(Math.max(0.0f, vals[i]), 1.0f);
        }
        return Color.getHSBColor(vals[0], vals[1], vals[2]);
    }

    public static Color deriveForeground(Color bg, float hue) {
        return ColorUtils.deriveForeground(bg, hue, 1.0f);
    }

    public static Color contrastForegroundColor(Color color) {
        float[] rgbs = new float[3];
        color.getRGBColorComponents(rgbs);
        int fR = (double)rgbs[0] > 0.5 ? 0 : 1;
        int fG = (double)rgbs[1] > 0.5 ? 0 : 1;
        int fB = (double)rgbs[2] > 0.5 ? 0 : 1;
        double luminance = 0.2126 * (double)(fR * fR) + 0.7152 * (double)(fG * fG) + 0.0722 * (double)(fB * fB);
        Color foreground = Color.WHITE;
        if (luminance < 0.54) {
            foreground = Color.BLACK;
        }
        return foreground;
    }

    public static Color blend(Color c1, Color c2, double ratio) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        int red = ColorUtils.blend(c1.getRed(), c2.getRed(), ratio);
        int green = ColorUtils.blend(c1.getGreen(), c2.getRed(), ratio);
        int blue = ColorUtils.blend(c1.getBlue(), c2.getBlue(), ratio);
        int alpha = ColorUtils.blend(c1.getAlpha(), c2.getAlpha(), ratio);
        return new Color(red, green, blue, alpha);
    }

    public static Color addColors(Color primary, Color secondary) {
        boolean bright1 = ColorUtils.isBright(primary);
        boolean bright2 = ColorUtils.isBright(secondary);
        if (bright1 && bright2) {
            return ColorUtils.combineDarker(primary, secondary);
        }
        if (!bright1 && !bright2) {
            return ColorUtils.combineBrighter(primary, secondary);
        }
        return ColorUtils.average(primary, secondary);
    }

    private static Color combineDarker(Color primary, Color secondary) {
        int red = ColorUtils.combineDarker(primary.getRed(), secondary.getRed());
        int green = ColorUtils.combineDarker(primary.getGreen(), secondary.getGreen());
        int blue = ColorUtils.combineDarker(primary.getBlue(), secondary.getBlue());
        return new Color(red, green, blue);
    }

    private static Color combineBrighter(Color primary, Color secondary) {
        int red = ColorUtils.combineBrighter(primary.getRed(), secondary.getRed());
        int green = ColorUtils.combineBrighter(primary.getGreen(), secondary.getGreen());
        int blue = ColorUtils.combineBrighter(primary.getBlue(), secondary.getBlue());
        return new Color(red, green, blue);
    }

    private static int combineDarker(int primary, int secondary) {
        int nudge = Math.min(255 - secondary, 32);
        return Math.max(primary - nudge, 0);
    }

    private static int combineBrighter(int primary, int secondary) {
        int nudge = Math.min(secondary, 32);
        return Math.max(primary + nudge, 0);
    }

    private static boolean isBright(Color color) {
        if (color.getRed() > 127) {
            return true;
        }
        if (color.getGreen() > 127) {
            return true;
        }
        return color.getBlue() > 127;
    }

    private static int blend(int colorValue1, int colorValue2, double ratio) {
        double value = (double)colorValue1 * ratio + (double)colorValue2 * (1.0 - ratio);
        int result = (int)(value + 0.5);
        return Math.min(result, 255);
    }

    public static Color withAlpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color getColor(int rgba) {
        return new Color(rgba, true);
    }

    public static Color getColor(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static Color getColor(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    public static Color getOpaqueColor(int rgb) {
        return new Color(rgb);
    }

    public static Color average(Color color1, Color color2) {
        int red = (color1.getRed() + color2.getRed()) / 2;
        int green = (color1.getGreen() + color2.getGreen()) / 2;
        int blue = (color1.getBlue() + color2.getBlue()) / 2;
        int alpha = (color1.getAlpha() + color2.getAlpha()) / 2;
        return new Color(red, green, blue, alpha);
    }

    public static class ColorBlender {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;

        public void add(Color color) {
            int ca = color.getAlpha();
            this.a += ca;
            this.r += ca * color.getRed();
            this.g += ca * color.getGreen();
            this.b += ca * color.getBlue();
        }

        public void clear() {
            this.r = 0;
            this.g = 0;
            this.b = 0;
            this.a = 0;
        }

        public Color getColor(Color defaultColor) {
            if (this.a == 0) {
                return defaultColor;
            }
            return new Color(this.r / this.a, this.g / this.a, this.b / this.a);
        }
    }
}

