/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFLocation;
import ghidra.app.util.bin.format.dwarf.DWARFLocationList;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.DWARFRangeList;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DIEAggregate {
    private static final int MAX_FRAGMENT_COUNT = 20;
    private DebugInfoEntry[] fragments;

    public static DIEAggregate createFromHead(DebugInfoEntry die) {
        DebugInfoEntry tmp;
        DIEAggregate result = new DIEAggregate(new DebugInfoEntry[]{die});
        while ((tmp = result.getRefDIE(DWARFAttribute.DW_AT_abstract_origin)) != null && !result.hasOffset(tmp.getOffset()) && result.getFragmentCount() < 20) {
            result.addFragment(tmp);
        }
        tmp = result.getRefDIE(DWARFAttribute.DW_AT_specification);
        if (tmp != null) {
            result.addFragment(tmp);
        }
        result.flipFragments();
        return result;
    }

    public static DIEAggregate createSkipHead(DIEAggregate source) {
        if (source.fragments.length == 1) {
            return null;
        }
        DebugInfoEntry[] partialFrags = new DebugInfoEntry[source.fragments.length - 1];
        System.arraycopy(source.fragments, 1, partialFrags, 0, partialFrags.length);
        return new DIEAggregate(partialFrags);
    }

    public static DIEAggregate createSingle(DebugInfoEntry die) {
        DIEAggregate result = new DIEAggregate(new DebugInfoEntry[]{die});
        return result;
    }

    private DIEAggregate(DebugInfoEntry[] fragments) {
        this.fragments = fragments;
    }

    private void addFragment(DebugInfoEntry newDIE) {
        DebugInfoEntry[] tmp = new DebugInfoEntry[this.fragments.length + 1];
        System.arraycopy(this.fragments, 0, tmp, 1, this.fragments.length);
        tmp[0] = newDIE;
        this.fragments = tmp;
    }

    private void flipFragments() {
        ArrayUtils.reverse((Object[])this.fragments);
    }

    public int getFragmentCount() {
        return this.fragments.length;
    }

    public long getOffset() {
        return this.getHeadFragment().getOffset();
    }

    public long[] getOffsets() {
        long[] result = new long[this.fragments.length];
        for (int i = 0; i < this.fragments.length; ++i) {
            result[i] = this.fragments[i].getOffset();
        }
        return result;
    }

    public boolean hasOffset(long offset) {
        for (DebugInfoEntry fragment : this.fragments) {
            if (fragment.getOffset() != offset) continue;
            return true;
        }
        return false;
    }

    public long getDeclOffset() {
        return this.getLastFragment().getOffset();
    }

    public String getHexOffset() {
        return Long.toHexString(this.getHeadFragment().getOffset());
    }

    public DWARFTag getTag() {
        return this.getHeadFragment().getTag();
    }

    public DWARFCompilationUnit getCompilationUnit() {
        return this.getHeadFragment().getCompilationUnit();
    }

    public DWARFProgram getProgram() {
        return this.getHeadFragment().getProgram();
    }

    public DebugInfoEntry getLastFragment() {
        return this.fragments[this.fragments.length - 1];
    }

    public DebugInfoEntry getHeadFragment() {
        return this.fragments[0];
    }

    public DIEAggregate getDeclParent() {
        DebugInfoEntry declDIE = this.getLastFragment();
        DebugInfoEntry declParent = declDIE.getParent();
        return this.getProgram().getAggregate(declParent);
    }

    public DIEAggregate getParent() {
        DebugInfoEntry die = this.getHeadFragment();
        DebugInfoEntry parent = die.getParent();
        return this.getProgram().getAggregate(parent);
    }

    public int getDepth() {
        return this.getProgram().getParentDepth(this.getHeadFragment().getIndex());
    }

    private FoundAttribute findAttribute(DWARFAttribute attribute) {
        for (DebugInfoEntry die : this.fragments) {
            DWARFAttributeValue attrVal = die.findAttribute(attribute);
            if (attrVal == null) continue;
            return new FoundAttribute(attrVal, die);
        }
        return null;
    }

    public <T extends DWARFAttributeValue> T findAttributeInChildren(DWARFAttribute attribute, DWARFTag childTag, Class<T> clazz) {
        T attributeValue = this.getAttribute(attribute, clazz);
        if (attributeValue != null) {
            return attributeValue;
        }
        for (DebugInfoEntry childDIE : this.getChildren(childTag)) {
            DIEAggregate childDIEA = this.getProgram().getAggregate(childDIE);
            attributeValue = childDIEA.getAttribute(attribute, clazz);
            if (attributeValue == null) continue;
            return attributeValue;
        }
        return null;
    }

    public <T extends DWARFAttributeValue> T getAttribute(DWARFAttribute attribute, Class<T> clazz) {
        FoundAttribute attrInfo = this.findAttribute(attribute);
        return attrInfo != null ? (T)attrInfo.getValue(clazz) : null;
    }

    public DWARFAttributeValue getAttribute(DWARFAttribute attribute) {
        return this.getAttribute(attribute, DWARFAttributeValue.class);
    }

    public long getLong(DWARFAttribute attribute, long defaultValue) {
        DWARFNumericAttribute attr = this.getAttribute(attribute, DWARFNumericAttribute.class);
        return attr != null ? attr.getValue() : defaultValue;
    }

    public boolean getBool(DWARFAttribute attribute, boolean defaultValue) {
        DWARFBooleanAttribute val = this.getAttribute(attribute, DWARFBooleanAttribute.class);
        return val != null ? val.getValue() : defaultValue;
    }

    public String getString(DWARFAttribute attribute, String defaultValue) {
        DWARFAttributeValue dWARFAttributeValue;
        FoundAttribute attrInfo = this.findAttribute(attribute);
        if (attrInfo == null || !((dWARFAttributeValue = attrInfo.attr) instanceof DWARFStringAttribute)) {
            return defaultValue;
        }
        DWARFStringAttribute strAttr = (DWARFStringAttribute)dWARFAttributeValue;
        return strAttr.getValue(attrInfo.die.getCompilationUnit());
    }

    public String getName() {
        return this.getString(DWARFAttribute.DW_AT_name, null);
    }

    public long getUnsignedLong(DWARFAttribute attribute, long defaultValue) {
        DWARFNumericAttribute attr = this.getAttribute(attribute, DWARFNumericAttribute.class);
        return attr != null ? attr.getUnsignedValue() : defaultValue;
    }

    private DebugInfoEntry getRefDIE(DWARFAttribute attribute) {
        DWARFNumericAttribute val = this.getAttribute(attribute, DWARFNumericAttribute.class);
        if (val == null) {
            return null;
        }
        long offset = val.getUnsignedValue();
        DebugInfoEntry result = this.getProgram().getDIEByOffset(offset);
        if (result == null) {
            Msg.warn((Object)this, (Object)"Invalid reference value [%x]".formatted(offset));
            Msg.warn((Object)this, (Object)this.toString());
        }
        return result;
    }

    public DIEAggregate getRef(DWARFAttribute attribute) {
        DebugInfoEntry die = this.getRefDIE(attribute);
        return this.getProgram().getAggregate(die);
    }

    public DIEAggregate getContainingTypeRef() {
        return this.getRef(DWARFAttribute.DW_AT_containing_type);
    }

    public DIEAggregate getTypeRef() {
        return this.getRef(DWARFAttribute.DW_AT_type);
    }

    public String getSourceFile() {
        FoundAttribute attrInfo = this.findAttribute(DWARFAttribute.DW_AT_decl_file);
        if (attrInfo == null) {
            return null;
        }
        DWARFNumericAttribute attr = attrInfo.getValue(DWARFNumericAttribute.class);
        if (attr == null) {
            return null;
        }
        try {
            int fileNum = attr.getUnsignedIntExact();
            DWARFCompilationUnit cu = attrInfo.die.getCompilationUnit();
            DWARFLine line = cu.getLine();
            return line.getFilePath(fileNum, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<DebugInfoEntry> getChildren(DWARFTag childTag) {
        return this.getHeadFragment().getChildren(childTag);
    }

    public boolean hasAttribute(DWARFAttribute attribute) {
        return this.findAttribute(attribute) != null;
    }

    public DIEAggregate getAbstractInstance() {
        FoundAttribute aoAttr = this.findAttribute(DWARFAttribute.DW_AT_abstract_origin);
        if (aoAttr == null) {
            return null;
        }
        for (int aoIndex = 0; aoIndex < this.fragments.length; ++aoIndex) {
            if (this.fragments[aoIndex] != aoAttr.die) continue;
            DebugInfoEntry[] partialFrags = new DebugInfoEntry[this.fragments.length - aoIndex - 1];
            System.arraycopy(this.fragments, aoIndex + 1, partialFrags, 0, partialFrags.length);
            return new DIEAggregate(partialFrags);
        }
        throw new IllegalArgumentException("Should not get here");
    }

    public int parseInt(DWARFAttribute attribute, int defaultValue) throws IOException, DWARFExpressionException {
        DWARFAttributeValue attr = this.getAttribute(attribute);
        if (attr == null) {
            return defaultValue;
        }
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return this.assertValidInt(dnum.getValue());
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(this.getCompilationUnit());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return this.assertValidInt(evaluator.pop());
        }
        throw new IOException("Not integer attribute: %s".formatted(attr));
    }

    public long parseUnsignedLong(DWARFAttribute attribute, long defaultValue) throws IOException, DWARFExpressionException {
        FoundAttribute attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return defaultValue;
        }
        DWARFAttributeValue attr = attrInfo.attr;
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return dnum.getUnsignedValue();
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(attrInfo.die().getCompilationUnit());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return evaluator.pop();
        }
        throw new IOException("Not integer attribute: %s".formatted(attr));
    }

    private int assertValidInt(long l) throws DWARFException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new DWARFException("Value out of allowed range: " + l);
        }
        return (int)l;
    }

    private int assertValidUInt(long l) throws DWARFException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new DWARFException("Value out of allowed range: " + l);
        }
        return (int)l;
    }

    public int parseDataMemberOffset(DWARFAttribute attribute, int defaultValue) throws DWARFExpressionException, IOException {
        DWARFAttributeValue attr = this.getAttribute(attribute);
        if (attr == null) {
            return defaultValue;
        }
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return dnum.getUnsignedIntExact();
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(this.getCompilationUnit());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return this.assertValidUInt(evaluator.pop());
        }
        throw new DWARFException("DWARF attribute form not valid for data member offset: %s".formatted(new Object[]{attr.getAttributeForm()}));
    }

    public DWARFLocationList getLocationList(DWARFAttribute attribute) throws IOException {
        return this.getProgram().getLocationList(this, attribute);
    }

    public DWARFLocation getLocation(DWARFAttribute attribute, long pc) throws IOException {
        DWARFLocationList locList = this.getLocationList(attribute);
        return locList.getLocationContaining(pc);
    }

    public boolean isDanglingDeclaration() {
        return this.isPartialDeclaration() && this.fragments.length == 1;
    }

    public boolean isPartialDeclaration() {
        return this.hasAttribute(DWARFAttribute.DW_AT_declaration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DIEAgregrate of: ");
        for (DebugInfoEntry die : this.fragments) {
            sb.append("DIE [0x%x], ".formatted(die.getOffset()));
        }
        sb.append("\n");
        for (DebugInfoEntry die : this.fragments) {
            sb.append(die.toString());
        }
        return sb.toString();
    }

    public DWARFRangeList getRangeList(DWARFAttribute attribute) throws IOException {
        return this.getProgram().getRangeList(this, attribute);
    }

    public DWARFRange getPCRange() {
        DWARFNumericAttribute lowPc = this.getAttribute(DWARFAttribute.DW_AT_low_pc, DWARFNumericAttribute.class);
        if (lowPc != null) {
            try {
                long lowPcOffset;
                long rawLowPc = lowPc.getUnsignedValue();
                long highPcOffset = lowPcOffset = this.getProgram().getAddress(lowPc.getAttributeForm(), rawLowPc, this.getCompilationUnit());
                DWARFNumericAttribute highPc = this.getAttribute(DWARFAttribute.DW_AT_high_pc, DWARFNumericAttribute.class);
                if (highPc != null) {
                    if (highPc.getAttributeForm() == DWARFForm.DW_FORM_addr) {
                        highPcOffset = highPc.getUnsignedValue();
                    } else {
                        highPcOffset = highPc.getUnsignedValue();
                        highPcOffset = lowPcOffset + highPcOffset;
                    }
                }
                return new DWARFRange(lowPcOffset, highPcOffset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DWARFRange.EMPTY;
    }

    public List<DIEAggregate> getFunctionParamList() {
        ArrayList<DIEAggregate> params = new ArrayList<DIEAggregate>();
        for (DebugInfoEntry paramDIE : this.getChildren(DWARFTag.DW_TAG_formal_parameter)) {
            DIEAggregate paramDIEA = this.getProgram().getAggregate(paramDIE);
            params.add(paramDIEA);
        }
        DIEAggregate abstractDIEA = this.getAbstractInstance();
        if (abstractDIEA != null) {
            ArrayList<DIEAggregate> newParams = new ArrayList<DIEAggregate>();
            for (DebugInfoEntry paramDIE : abstractDIEA.getChildren(DWARFTag.DW_TAG_formal_parameter)) {
                int index = DIEAggregate.findDIEInList(params, paramDIE);
                if (index >= 0) {
                    newParams.add((DIEAggregate)params.get(index));
                    params.remove(index);
                    continue;
                }
                newParams.add(this.getProgram().getAggregate(paramDIE));
            }
            if (!params.isEmpty()) {
                newParams.addAll(params);
            }
            params = newParams;
        }
        return params;
    }

    private static int findDIEInList(List<DIEAggregate> dieas, DebugInfoEntry die) {
        for (int i = 0; i < dieas.size(); ++i) {
            if (!dieas.get(i).hasOffset(die.getOffset())) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fragments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DIEAggregate)) {
            return false;
        }
        DIEAggregate other = (DIEAggregate)obj;
        return Arrays.equals(this.fragments, other.fragments);
    }

    record FoundAttribute(DWARFAttributeValue attr, DebugInfoEntry die) {
        <T extends DWARFAttributeValue> T getValue(Class<T> clazz) {
            if (this.attr != null && clazz.isAssignableFrom(this.attr.getClass())) {
                return (T)((DWARFAttributeValue)clazz.cast(this.attr));
            }
            return null;
        }
    }
}

