/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.debug.disassemble.CurrentPlatformTraceDisassembleCommand;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;

public class CurrentPlatformTraceDisassembleAction
extends DockingAction {
    private static final String NAME = "Disassemble";
    private static final String MENU_GROUP = "Disassembly";
    private static final KeyBindingData KEY_BINDING = new KeyBindingData("D");
    private final PluginTool tool;

    public CurrentPlatformTraceDisassembleAction(DebuggerDisassemblerPlugin plugin) {
        super(NAME, plugin.getName());
        this.tool = plugin.getTool();
        this.setPopupMenuData(new MenuData(new String[]{NAME}, MENU_GROUP));
        this.setKeyBindingData(KEY_BINDING);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "disassemble"));
    }

    public boolean isAddToPopup(ActionContext context) {
        CurrentPlatformTraceDisassembleCommand.Reqs reqs = CurrentPlatformTraceDisassembleCommand.Reqs.fromContext(this.tool, context);
        return reqs != null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        CurrentPlatformTraceDisassembleCommand.Reqs reqs = CurrentPlatformTraceDisassembleCommand.Reqs.fromContext(this.tool, context);
        if (reqs == null) {
            return false;
        }
        return super.isEnabledForContext(context);
    }

    public void actionPerformed(ActionContext context) {
        CurrentPlatformTraceDisassembleCommand.Reqs reqs = CurrentPlatformTraceDisassembleCommand.Reqs.fromContext(this.tool, context);
        if (reqs == null) {
            return;
        }
        ListingActionContext lac = (ListingActionContext)context;
        Address address = lac.getAddress();
        AddressSpace space = address.getAddressSpace();
        ProgramSelection selection = lac.getSelection();
        Object set = selection != null && !selection.isEmpty() ? selection : reqs.view().getAddressFactory().getAddressSet(space.getMinAddress(), space.getMaxAddress());
        CurrentPlatformTraceDisassembleCommand cmd = new CurrentPlatformTraceDisassembleCommand(this.tool, (AddressSetView)set, reqs, address);
        cmd.run(this.tool, (DomainObject)reqs.view());
    }
}

