/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.pty.Pty;
import ghidra.pty.PtyChild;
import ghidra.pty.PtyParent;
import ghidra.pty.windows.ConPtyChild;
import ghidra.pty.windows.ConPtyParent;
import ghidra.pty.windows.Pipe;
import ghidra.pty.windows.PseudoConsoleHandle;
import ghidra.pty.windows.jna.ConsoleApiNative;
import java.io.IOException;

public class ConPty
implements Pty {
    static final WinDef.DWORD DW_ZERO = new WinDef.DWORD(0L);
    static final WinDef.DWORD DW_ONE = new WinDef.DWORD(1L);
    static final WinDef.DWORD PROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE = new WinDef.DWORD(131094L);
    static final WinDef.DWORD EXTENDED_STARTUPINFO_PRESENT = new WinDef.DWORD(524288L);
    private final Pipe pipeToChild;
    private final Pipe pipeFromChild;
    private final PseudoConsoleHandle pseudoConsoleHandle;
    private boolean closed = false;
    private final ConPtyParent parent;
    private final ConPtyChild child;

    public static ConPty openpty(short cols, short rows) {
        Pipe pipeToChild = Pipe.createPipe();
        Pipe pipeFromChild = Pipe.createPipe();
        WinNT.HANDLEByReference lphPC = new WinNT.HANDLEByReference();
        ConsoleApiNative.COORD.ByValue size = new ConsoleApiNative.COORD.ByValue();
        size.X = cols;
        size.Y = rows;
        COMUtils.checkRC((WinNT.HRESULT)ConsoleApiNative.INSTANCE.CreatePseudoConsole(size, pipeToChild.getReadHandle().getNative(), pipeFromChild.getWriteHandle().getNative(), DW_ZERO, lphPC));
        return new ConPty(pipeToChild, pipeFromChild, new PseudoConsoleHandle(lphPC.getValue()));
    }

    public ConPty(Pipe pipeToChild, Pipe pipeFromChild, PseudoConsoleHandle pseudoConsoleHandle) {
        this.pipeToChild = pipeToChild;
        this.pipeFromChild = pipeFromChild;
        this.pseudoConsoleHandle = pseudoConsoleHandle;
        this.parent = new ConPtyParent(pipeToChild.getWriteHandle(), pipeFromChild.getReadHandle(), pseudoConsoleHandle);
        this.child = new ConPtyChild(pipeFromChild.getWriteHandle(), pipeToChild.getReadHandle(), pseudoConsoleHandle);
    }

    @Override
    public PtyParent getParent() {
        return this.parent;
    }

    @Override
    public PtyChild getChild() {
        return this.child;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.pseudoConsoleHandle.close();
            this.pipeToChild.close();
            this.pipeFromChild.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.closed = true;
    }
}

