/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import java.awt.Point;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoResultAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GotoResultAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoResultAction.$$$reportNull$$$0(1);
        }
        DataGrid grid = GridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(grid != null && this.isEnabled(grid, e));
    }

    protected abstract boolean isEnabled(@NotNull DataGrid var1, @NotNull AnActionEvent var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            GotoResultAction.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        RunnerLayoutUi ui = (RunnerLayoutUi)e.getData(DatabaseDataKeys.DATA_GRID_RUNNER_LAYOUT_UI_KEY);
        if (ui == null) {
            return;
        }
        Predicate<Content> resultPredicate = this.getResultPredicate(grid, e);
        if (resultPredicate == null) {
            return;
        }
        for (Content content : ui.getContents()) {
            ContentManager manager;
            if (!resultPredicate.test(content)) continue;
            ContentManager contentManager = manager = content.isValid() ? content.getManager() : null;
            if (manager != null) {
                manager.setSelectedContent(content, false, false);
            }
            return;
        }
        JBLoadingPanel component = grid.getPanel().getComponent();
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$actionPerformed$0((Component)component));
    }

    @Nullable
    protected abstract Predicate<Content> getResultPredicate(@NotNull DataGrid var1, @NotNull AnActionEvent var2);

    @Nls
    @NotNull
    protected abstract String getErrorMessage();

    @NotNull
    protected static Point getErrorPosition(@NotNull Component component) {
        Point mousePosition;
        if (component == null) {
            GotoResultAction.$$$reportNull$$$0(3);
        }
        return (mousePosition = component.getMousePosition()) != null ? mousePosition : new Point(0, 0);
    }

    private /* synthetic */ void lambda$actionPerformed$0(Component component) {
        if (!component.isValid()) {
            return;
        }
        GridUtil.showErrorBalloon(SimpleErrorInfo.create((String)this.getErrorMessage()), component, GotoResultAction.getErrorPosition(component));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GotoResultAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GotoResultAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

