/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AugmentedAssignmentQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyAugmentAssignmentInspection
extends PyInspection {
    @NotNull
    private static final TokenSet OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.PLUS, PyTokenTypes.MINUS, PyTokenTypes.MULT, PyTokenTypes.FLOORDIV, PyTokenTypes.DIV, PyTokenTypes.PERC, PyTokenTypes.AND, PyTokenTypes.OR, PyTokenTypes.XOR, PyTokenTypes.LTLT, PyTokenTypes.GTGT, PyTokenTypes.EXP});
    @NotNull
    private static final TokenSet COMMUTATIVE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.PLUS, PyTokenTypes.MULT, PyTokenTypes.OR, PyTokenTypes.AND});
    @NotNull
    private static final List<String> SEQUENCE_METHODS = Arrays.asList("__len__", "__iter__", "__getitem__", "__contains__");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAugmentAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAugmentAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyAugmentAssignmentInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyExpression target = node.getLeftHandSideExpression();
            PyBinaryExpression value = PyUtil.as(node.getAssignedValue(), PyBinaryExpression.class);
            if (target != null && value != null && node.getTargets().length == 1) {
                boolean changedParts;
                PyExpression otherOperandExpression;
                PyExpression mainOperandExpression;
                PyExpression leftExpression = value.getLeftExpression();
                PyExpression rightExpression = PyPsiUtils.flattenParens((PyExpression)value.getRightExpression());
                if (leftExpression == null || rightExpression == null) {
                    return;
                }
                String targetText = target.getText();
                if (targetText.equals(leftExpression.getText())) {
                    mainOperandExpression = leftExpression;
                    otherOperandExpression = rightExpression;
                    changedParts = false;
                } else if (targetText.equals(rightExpression.getText())) {
                    mainOperandExpression = rightExpression;
                    otherOperandExpression = leftExpression;
                    changedParts = true;
                } else {
                    return;
                }
                PyElementType operator = value.getOperator();
                if (operator != null && this.assignmentCanBeReplaced(mainOperandExpression, otherOperandExpression, operator, changedParts)) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.assignment.can.be.replaced.with.augmented.assignment", new Object[0]), new LocalQuickFix[]{new AugmentedAssignmentQuickFix()});
                }
            }
        }

        private boolean assignmentCanBeReplaced(@NotNull PyExpression mainOperandExpression, @NotNull PyExpression otherOperandExpression, @NotNull PyElementType operator, boolean changedParts) {
            PyType otherOperandType;
            if (mainOperandExpression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (otherOperandExpression == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (operator == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (!(mainOperandExpression instanceof PyReferenceExpression) && !(mainOperandExpression instanceof PySubscriptionExpression)) {
                return false;
            }
            if ((!changedParts && OPERATIONS.contains((IElementType)operator) || changedParts && COMMUTATIVE_OPERATIONS.contains((IElementType)operator)) && !PyTypeChecker.isUnknown(otherOperandType = this.myTypeEvalContext.getType((PyTypedElement)otherOperandExpression), this.myTypeEvalContext)) {
                if (changedParts) {
                    if (this.hasAnySequenceMethod(otherOperandType, otherOperandExpression)) {
                        return false;
                    }
                    PyType mainOperandType = this.myTypeEvalContext.getType((PyTypedElement)mainOperandExpression);
                    if (mainOperandType != null && this.hasAnySequenceMethod(mainOperandType, mainOperandExpression)) {
                        return false;
                    }
                }
                return this.isNumeric(otherOperandType, PyBuiltinCache.getInstance((PsiElement)otherOperandExpression)) || this.hasAnySequenceMethod(otherOperandType, otherOperandExpression);
            }
            return false;
        }

        private boolean hasAnySequenceMethod(@NotNull PyType type, @NotNull PyExpression location) {
            if (type == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (location == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (type instanceof PyStructuralType) {
                Set<String> attributeNames = ((PyStructuralType)type).getAttributeNames();
                return SEQUENCE_METHODS.stream().anyMatch(attributeNames::contains);
            }
            PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext);
            return !SEQUENCE_METHODS.stream().map(method -> type.resolveMember(method, location, AccessDirection.READ, resolveContext)).allMatch(ContainerUtil::isEmpty);
        }

        private boolean isNumeric(@NotNull PyType type, @NotNull PyBuiltinCache cache) {
            if (type == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (cache == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            return PyTypeChecker.match((PyType)cache.getComplexType(), type, this.myTypeEvalContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainOperandExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherOperandExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAugmentAssignmentInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assignmentCanBeReplaced";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasAnySequenceMethod";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNumeric";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

