/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import com.ibm.db2.cmx.tools.internal.generator.codegen.MethodGenerator;
import com.ibm.db2.cmx.tools.internal.generator.codegen.QOCMetaDataGenerator;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;

public class ClassGenerator {
    public static Calendar calendar__;
    public static SimpleDateFormat simpleDateFormat__;
    private StringBuilder stringBuffer_ = new StringBuilder();
    private ClassInfo classInfo_;
    private GeneratorImpl generatorImpl_;

    public ClassGenerator(ClassInfo classInfo, GeneratorImpl generatorImpl) {
        this.classInfo_ = classInfo;
        this.generatorImpl_ = generatorImpl;
    }

    public String generate() {
        ToolsLogger.getLogger().log(Level.FINEST, "generating implementation from class information: " + this.classInfo_.toString());
        this.setMethodIndex();
        this.setAllMethodPrefixes();
        this.generateClassHeader();
        this.generateMethods();
        if (this.classInfo_.getVtiMetadataMap() != null) {
            try {
                this.generateQOCMetaData();
            }
            catch (SQLException sQLException) {
                ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("MSG_GEN_FAIL", this.classInfo_.getQualifiedInterfaceName()), sQLException, 10504);
            }
        }
        this.generateClassFooter();
        return this.stringBuffer_.toString();
    }

    private void generateQOCMetaData() throws SQLException {
        QOCMetaDataGenerator qOCMetaDataGenerator = new QOCMetaDataGenerator(this.classInfo_, this.stringBuffer_);
        qOCMetaDataGenerator.generate();
    }

    private void setMethodIndex() {
        int n2 = 1;
        for (MethodInfo methodInfo : this.classInfo_.getListOfMethods()) {
            methodInfo.setValue(n2++);
        }
    }

    private void setAllMethodPrefixes() {
        HashMap hashMap = new HashMap();
        List<MethodInfo> list = this.classInfo_.getListOfMethods();
        for (MethodInfo methodInfo : list) {
            String string = methodInfo.getMethodName();
            while (hashMap.containsKey(string)) {
                string = string + "_";
            }
            hashMap.put(string, null);
            methodInfo.setPrefixForObjectNames(string);
        }
    }

    private void generateClassFooter() {
        this.stringBuffer_.append("}\n");
    }

    private void generateMethods() {
        MethodGenerator methodGenerator = new MethodGenerator(this.classInfo_, this.stringBuffer_, this.generatorImpl_);
        for (MethodInfo methodInfo : this.classInfo_.getListOfMethods()) {
            methodGenerator.generate(methodInfo);
        }
    }

    private void generateClassHeader() {
        String string3;
        String string2 = this.classInfo_.getPackageName();
        if (!"".equals(string2)) {
            this.stringBuffer_.append("package " + this.classInfo_.getPackageName() + ";\n\n");
        }
        Set<String> set = this.classInfo_.getListOfImportDeclaration();
        boolean bl2 = false;
        if (set.contains("com.ibm.db2.jcc.DBTimestamp")) {
            bl2 = true;
        }
        for (String string3 : set) {
            this.stringBuffer_.append("import " + string3 + ";\n");
        }
        String string4 = this.classInfo_.getArtifactOptionsSet().getOptionOrArtifactSingleValue(PossibleArgs.BASE_DATA_OVERRIDE);
        this.stringBuffer_.append("\n\n");
        this.generateCommentsForClass("", "@generated");
        string3 = this.classInfo_.getTypeName() + "Impl";
        this.stringBuffer_.append("public class " + string3 + "  extends " + (String)string4 + " implements " + this.classInfo_.getTypeName() + "\n{\n");
        this.stringBuffer_.append("\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public static final String generatorVersion = \"" + DataVersion.getProductVersion() + "\";\n\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public static final String identifier = \"" + this.classInfo_.getRootPkgName() + "\";\n\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public static final long generationTime = 0x" + StatementDescriptorImpl.getTimestampAsString(this.classInfo_.getTimeStamp()) + "L;\n\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public static final String collection = \"" + this.classInfo_.getCollectionName() + "\";\n\n");
        if (this.classInfo_.isPackageVersionAutoGenerated()) {
            this.generateComments("  ", "packageVersion was automatically generated because AUTO was specified", "@generated");
        } else {
            this.generateComments("  ", "@generated");
        }
        String string5 = this.classInfo_.getPackageVersion();
        String string6 = null == string5 ? null : "\"" + string5 + "\"";
        this.stringBuffer_.append("  public static final String packageVersion = " + string6 + ";\n\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public static final boolean forceSingleBindIsolation = " + this.classInfo_.isForceSingleBindIsolation() + ";\n\n");
        if (bl2) {
            this.stringBuffer_.append("  static {\n");
            this.stringBuffer_.append("    " + (String)string4 + ".checkDriverVersion (\"" + string3 + "\");\n");
            this.stringBuffer_.append("  }\n\n");
        }
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public " + string3 + "()\n  {\n    super();\n  } \n\n");
        this.generateComments("  ", "@generated");
        this.stringBuffer_.append("  public String getGeneratorVersion()\n  {\n    return generatorVersion;\n  }\n\n");
    }

    private void generateCommentsForClass(String string, String string2) {
        this.stringBuffer_.append(string + "/**\n");
        this.stringBuffer_.append(string + " * <!-- begin-user-doc -->\n");
        this.stringBuffer_.append(string + " * \n");
        this.stringBuffer_.append(string + " * <!-- end-user-doc -->\n");
        this.stringBuffer_.append(string + " * \n");
        this.stringBuffer_.append(string + " * " + string2 + "\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    private void generateComments(String string, String string2) {
        this.stringBuffer_.append(string + "/**\n");
        this.stringBuffer_.append(string + " * " + string2 + "\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    private void generateComments(String string, String string2, String string3) {
        this.stringBuffer_.append(string + "/**\n");
        if (null != string2) {
            this.stringBuffer_.append(string + " * " + string2 + "\n");
        }
        this.stringBuffer_.append(string + " * " + string3 + "\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    static {
        TimeZone timeZone = TimeZone.getDefault();
        String string = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        simpleDateFormat__ = new SimpleDateFormat(string);
        simpleDateFormat__.setTimeZone(timeZone);
        calendar__ = Calendar.getInstance(timeZone);
    }
}

