/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.Version;
import org.firebirdsql.jaybird.props.InvalidPropertyValueException;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.jdbc.FirebirdDriver;
import org.firebirdsql.logging.LoggerFactory;

public class FBDriver
implements FirebirdDriver {
    private static final org.firebirdsql.logging.Logger log = LoggerFactory.getLogger(FBDriver.class);
    @Deprecated
    public static final String CHARSET = "charSet";
    @Deprecated
    public static final String USER = "user";
    @Deprecated
    public static final String USER_NAME = "user_name";
    @Deprecated
    public static final String PASSWORD = "password";
    @Deprecated
    public static final String DATABASE = "database";
    @Deprecated
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    @Deprecated
    public static final String TPB_MAPPING = "tpb_mapping";
    private static final String URL_CHARSET = "UTF-8";
    private final Map<FBConnectionProperties, Reference<FBDataSource>> mcfToDataSourceMap = new ConcurrentHashMap<FBConnectionProperties, Reference<FBDataSource>>();
    private final ReferenceQueue<FBDataSource> dataSourceReferenceQueue = new ReferenceQueue();
    private final Object createDataSourceLock = new Object();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        GDSType type = GDSFactory.getTypeForProtocol(url);
        if (type == null) {
            return null;
        }
        Map<String, String> mergedProperties = FBDriver.mergeProperties(url, info);
        try {
            int qMarkIndex = url.indexOf(63);
            if (qMarkIndex != -1) {
                url = url.substring(0, qMarkIndex);
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            String databaseURL = GDSFactory.getDatabasePath(type, url);
            mcf.setDatabaseName(databaseURL);
            for (Map.Entry<String, String> entry : mergedProperties.entrySet()) {
                try {
                    mcf.setProperty(entry.getKey(), entry.getValue());
                }
                catch (InvalidPropertyValueException e) {
                    throw e.asSQLException();
                }
            }
            FBTpbMapper.processMapping((FirebirdConnectionProperties)mcf, mergedProperties);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return dataSource.getConnection(mcf.getUser(), mcf.getPassword());
        }
        catch (GDSException e) {
            throw new FBSQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBDataSource createDataSource(FBManagedConnectionFactory mcf) {
        FBConnectionProperties cacheKey = mcf.getCacheKey();
        FBDataSource dataSource = this.dataSourceFromCache(cacheKey);
        if (dataSource != null) {
            return dataSource;
        }
        Object object = this.createDataSourceLock;
        synchronized (object) {
            dataSource = this.dataSourceFromCache(cacheKey);
            if (dataSource == null) {
                dataSource = (FBDataSource)mcf.createConnectionFactory();
                this.mcfToDataSourceMap.put(cacheKey, new SoftReference<FBDataSource>(dataSource, this.dataSourceReferenceQueue));
            }
        }
        this.cleanDataSourceCache();
        return dataSource;
    }

    private void cleanDataSourceCache() {
        Reference<FBDataSource> reference;
        while ((reference = this.dataSourceReferenceQueue.poll()) != null) {
            this.mcfToDataSourceMap.values().remove(reference);
        }
    }

    private FBDataSource dataSourceFromCache(FBConnectionProperties cacheKey) {
        Reference<FBDataSource> dataSourceReference = this.mcfToDataSourceMap.get(cacheKey);
        return dataSourceReference != null ? dataSourceReference.get() : null;
    }

    @Override
    public FirebirdConnection connect(FirebirdConnectionProperties properties) throws SQLException {
        GDSType type = GDSType.getType(properties.getType());
        if (type == null) {
            type = GDSFactory.getDefaultGDSType();
        }
        FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type, (FBConnectionProperties)properties).canonicalize();
        FBDataSource dataSource = this.createDataSource(mcf);
        return (FirebirdConnection)dataSource.getConnection(mcf.getUser(), mcf.getPassword());
    }

    @Override
    public FirebirdConnectionProperties newConnectionProperties() {
        return new FBConnectionProperties();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        for (String protocol : GDSFactory.getSupportedProtocols()) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return FBDriverPropertyManager.getDriverPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return Version.JAYBIRD_MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return Version.JAYBIRD_MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new FBDriverNotCapableException("Method getParentLogger() not supported");
    }

    public static Map<String, String> normalizeProperties(String jdbcUrl, Properties connectionProperties) throws SQLException {
        Map<String, String> mergedProperties = FBDriver.mergeProperties(jdbcUrl, connectionProperties);
        return FBDriverPropertyManager.normalize(mergedProperties);
    }

    private static Map<String, String> mergeProperties(String jdbcUrl, Properties connectionProperties) throws SQLException {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        if (connectionProperties != null) {
            for (String propertyName : connectionProperties.stringPropertyNames()) {
                mergedProperties.put(propertyName, connectionProperties.getProperty(propertyName));
            }
        }
        FBDriver.convertUrlParams(jdbcUrl, mergedProperties);
        return mergedProperties;
    }

    private static void convertUrlParams(String url, Map<String, String> info) throws SQLException {
        if (url == null) {
            return;
        }
        int iQuestionMark = url.indexOf("?");
        if (iQuestionMark == -1) {
            return;
        }
        String propString = url.substring(iQuestionMark + 1);
        StringTokenizer st = new StringTokenizer(propString, "&;");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            int iIs = propertyString.indexOf("=");
            if (iIs > -1) {
                String property = FBDriver.urlDecode(propertyString.substring(0, iIs), url);
                String value = FBDriver.urlDecode(propertyString.substring(iIs + 1), url);
                info.put(property, value);
                continue;
            }
            info.put(FBDriver.urlDecode(propertyString, url), "");
        }
    }

    private static String urlDecode(String encodedValue, String url) throws SQLException {
        try {
            return URLDecoder.decode(encodedValue, URL_CHARSET);
        }
        catch (UnsupportedEncodingException | RuntimeException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(url).messageParameter(e.toString()).cause(e).toSQLException();
        }
    }

    static {
        try {
            DriverManager.registerDriver(new FBDriver());
        }
        catch (Exception ex) {
            log.error("Could not register with driver manager", ex);
        }
    }
}

