/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.stereo;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.LocationSensorParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoUtil;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceConfig;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceFactory;
import jogamp.opengl.util.stereo.GenericStereoDeviceRenderer;

public class GenericStereoDevice
implements StereoDevice {
    public static final GenericStereoDeviceConfig config01Mono01;
    public static final GenericStereoDeviceConfig config01Mono02;
    public static final GenericStereoDeviceConfig config02StereoSBS01;
    public static final GenericStereoDeviceConfig config02StereoSBS02;
    public static final GenericStereoDeviceConfig config03StereoSBSLense01;
    public static final GenericStereoDeviceConfig config03StereoSBSLense02;
    private static final GenericStereoDeviceConfig[] configs;
    private final StereoDeviceFactory factory;
    public final int deviceIndex;
    public final GenericStereoDeviceConfig config;
    public final Point surfacePos;
    private final FovHVHalves[] defaultEyeFov;
    private int usedSensorBits;
    private boolean sensorsStarted = false;

    public GenericStereoDevice(StereoDeviceFactory stereoDeviceFactory, int n, StereoDeviceConfig stereoDeviceConfig) {
        int n2;
        this.factory = stereoDeviceFactory;
        this.deviceIndex = n;
        this.config = stereoDeviceConfig instanceof GenericStereoDeviceConfig ? (GenericStereoDeviceConfig)stereoDeviceConfig : (null != configs[n2 = Math.min(n % 10, configs.length - 1)] ? configs[n2] : config02StereoSBS01);
        this.config.init();
        this.surfacePos = new Point(0, 0);
        this.defaultEyeFov = new FovHVHalves[this.config.defaultEyeParam.length];
        for (n2 = 0; n2 < this.defaultEyeFov.length; ++n2) {
            this.defaultEyeFov[n2] = this.config.defaultEyeParam[n2].fovhv;
        }
        this.usedSensorBits = 0;
    }

    @Override
    public final StereoDeviceFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return "GenericStereoDevice[" + this.config + ", surfacePos " + this.surfacePos + ", sensorBits[enabled [" + StereoUtil.sensorBitsToString(this.getEnabledSensorBits()) + "]]]";
    }

    public void setSurfacePosition(int n, int n2) {
        this.surfacePos.set(n, n2);
    }

    @Override
    public final void dispose() {
        this.stopSensors();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public final PointImmutable getPosition() {
        return this.surfacePos;
    }

    @Override
    public final DimensionImmutable getSurfaceSize() {
        return this.config.surfaceSizeInPixels;
    }

    @Override
    public int getRequiredRotation() {
        return 0;
    }

    @Override
    public Vec3f getDefaultEyePositionOffset() {
        return this.config.defaultEyeParam[0].positionOffset;
    }

    @Override
    public final FovHVHalves[] getDefaultFOV() {
        return this.defaultEyeFov;
    }

    @Override
    public final LocationSensorParameter getLocationSensorParams() {
        return null;
    }

    @Override
    public final void resetLocationSensorOrigin() {
    }

    @Override
    public final boolean startSensors(int n, int n2) {
        if (!this.sensorsStarted) {
            if (n2 != (this.config.supportedSensorBits & n2)) {
                return false;
            }
            if (0 == (this.config.supportedSensorBits & (n2 | n))) {
                return false;
            }
            if (this.startSensorsImpl(true, n, n2)) {
                this.sensorsStarted = true;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean startSensorsImpl(boolean bl, int n, int n2) {
        return false;
    }

    @Override
    public final boolean stopSensors() {
        if (this.sensorsStarted) {
            if (this.startSensorsImpl(false, 0, 0)) {
                this.sensorsStarted = false;
                this.usedSensorBits = 0;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean getSensorsStarted() {
        return this.sensorsStarted;
    }

    @Override
    public final int getSupportedSensorBits() {
        return this.config.supportedSensorBits;
    }

    @Override
    public final int getEnabledSensorBits() {
        return this.usedSensorBits;
    }

    @Override
    public int[] getEyeRenderOrder() {
        return this.config.eyeRenderOrder;
    }

    @Override
    public int getSupportedDistortionBits() {
        return this.config.supportedDistortionBits;
    }

    @Override
    public int getRecommendedDistortionBits() {
        return this.config.recommendedDistortionBits;
    }

    @Override
    public int getMinimumDistortionBits() {
        return this.config.minimumDistortionBits;
    }

    @Override
    public final StereoDeviceRenderer createRenderer(int n, int n2, Vec3f vec3f, FovHVHalves[] fovHVHalvesArray, float f, int n3) {
        DimensionImmutable dimensionImmutable;
        RectangleImmutable[] rectangleImmutableArray;
        int n4;
        EyeParameter[] eyeParameterArray = new EyeParameter[fovHVHalvesArray.length];
        for (n4 = 0; n4 < eyeParameterArray.length; ++n4) {
            rectangleImmutableArray = this.config.defaultEyeParam[n4];
            eyeParameterArray[n4] = new EyeParameter(n4, vec3f, fovHVHalvesArray[n4], rectangleImmutableArray.distNoseToPupilX, rectangleImmutableArray.distMiddleToPupilY, rectangleImmutableArray.eyeReliefZ);
        }
        n4 = null != this.config.distortionMeshProducer && 0 != n ? 1 : 0;
        rectangleImmutableArray = new RectangleImmutable[eyeParameterArray.length];
        if (1 < eyeParameterArray.length) {
            DimensionImmutable dimensionImmutable2 = this.config.eyeTextureSizes[0];
            DimensionImmutable dimensionImmutable3 = this.config.eyeTextureSizes[1];
            int n5 = Math.max(dimensionImmutable2.getHeight(), dimensionImmutable3.getHeight());
            dimensionImmutable = new Dimension(dimensionImmutable2.getWidth() + dimensionImmutable3.getWidth(), n5);
            if (1 == n2) {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), n5);
                rectangleImmutableArray[1] = new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable3.getWidth(), n5);
            } else if (n4 != 0) {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = new Rectangle(0, 0, dimensionImmutable3.getWidth(), dimensionImmutable3.getHeight());
            } else {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable3.getWidth(), dimensionImmutable3.getHeight());
            }
        } else {
            DimensionImmutable dimensionImmutable4;
            dimensionImmutable = dimensionImmutable4 = this.config.eyeTextureSizes[0];
            rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable4.getWidth(), dimensionImmutable4.getHeight());
        }
        return new GenericStereoDeviceRenderer(this, n, n2, vec3f, eyeParameterArray, f, n3, this.config.eyeTextureSizes, dimensionImmutable, rectangleImmutableArray);
    }

    static {
        Vec3f vec3f = new Vec3f(0.0f, 1.6f, -5.0f);
        Vec3f vec3f2 = new Vec3f(0.0f, 0.3f, 3.0f);
        Vec3f vec3f3 = new Vec3f(0.0f, 0.0f, 3.0f);
        Dimension dimension = new Dimension(1280, 800);
        float[] fArray = new float[]{0.14976f, 0.0936f};
        Dimension dimension2 = new Dimension(1122, 1553);
        Dimension dimension3 = new Dimension(1920, 1080);
        float[] fArray2 = new float[]{0.12576f, 0.07074f};
        Dimension dimension4 = new Dimension(1182, 1461);
        config01Mono01 = GenericStereoDeviceFactory.createMono("Def01Mono01", dimension, fArray, vec3f3);
        config02StereoSBS01 = GenericStereoDeviceFactory.createStereoSBS("Def02StereoSBS01", dimension, fArray, 0.0635f, 45.0f, vec3f2);
        config03StereoSBSLense01 = GenericStereoDeviceFactory.createStereoSBSLense("Def03StereoSBSLense01", dimension, fArray, 0.0635f, 129.0f, dimension2, vec3f);
        config01Mono02 = GenericStereoDeviceFactory.createMono("Def01Mono02", dimension3, fArray2, vec3f3);
        config02StereoSBS02 = GenericStereoDeviceFactory.createStereoSBS("Def02StereoSBS02", dimension3, fArray2, 0.0635f, 45.0f, vec3f2);
        config03StereoSBSLense02 = GenericStereoDeviceFactory.createStereoSBSLense("Def03StereoSBSLense02", dimension3, fArray2, 0.0635f, 129.0f, dimension4, vec3f);
        configs = new GenericStereoDeviceConfig[]{config01Mono01, config02StereoSBS01, config03StereoSBSLense01, config01Mono02, config02StereoSBS02, config03StereoSBSLense02};
    }
}

