/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tomcat.util.res.StringManager;

public class ToStringUtil {
    private static final StringManager sm = StringManager.getManager(ToStringUtil.class);
    private static final String INDENT = "    ";

    private ToStringUtil() {
    }

    public static String classPathForCNFE(ClassLoader classLoader) {
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append(sm.getString("toStringUtil.classpath.header"));
        stringBuilder.append("\n");
        while (classLoader != null) {
            ToStringUtil.classPathForCNFE(classLoader, stringBuilder);
            classLoader = classLoader.getParent();
        }
        return stringBuilder.toString();
    }

    private static void classPathForCNFE(ClassLoader classLoader, StringBuilder stringBuilder) {
        stringBuilder.append(INDENT);
        stringBuilder.append(sm.getString("toStringUtil.classpath.classloader", classLoader));
        stringBuilder.append("\n");
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray;
            for (URL uRL : uRLArray = ((URLClassLoader)classLoader).getURLs()) {
                stringBuilder.append(INDENT);
                stringBuilder.append(INDENT);
                stringBuilder.append(uRL);
                stringBuilder.append("\n");
            }
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            String string = System.getProperty("java.class.path");
            if (string != null && !string.isEmpty()) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(File.pathSeparator)) {
                    stringBuilder.append(INDENT);
                    stringBuilder.append(INDENT);
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                }
            }
        } else if (classLoader == ClassLoader.getPlatformClassLoader()) {
            stringBuilder.append(INDENT);
            stringBuilder.append(INDENT);
            stringBuilder.append(sm.getString("toStringUtil.classpath.platform"));
            stringBuilder.append("\n");
        } else {
            stringBuilder.append(INDENT);
            stringBuilder.append(INDENT);
            stringBuilder.append(sm.getString("toStringUtil.classpath.unknown"));
            stringBuilder.append("\n");
        }
    }
}

