/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericEvent;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventArray;

abstract class JFRGenericEventFactory {
    JFRGenericEventFactory() {
    }

    abstract JFRGenericEvent createEvent(IItem var1, long var2);

    static JFRGenericEventFactory resolve(EventArray[] types) {
        for (EventArray typeA : types) {
            IType<IItem> type = typeA.getType();
            if (type.getAccessor(JfrAttributes.END_TIME.getKey()) != null) {
                return new V0();
            }
            if (type.getAccessor(JfrAttributes.DURATION.getKey()) == null) continue;
            return new V1();
        }
        throw new RuntimeException("No JFRGenericEventFactory resolved!");
    }

    static class V1
    extends JFRGenericEventFactory {
        V1() {
        }

        @Override
        JFRGenericEvent createEvent(IItem item, long id) {
            return new JFRGenericEvent.V1(item, id);
        }
    }

    static class V0
    extends JFRGenericEventFactory {
        V0() {
        }

        @Override
        JFRGenericEvent createEvent(IItem item, long id) {
            return new JFRGenericEvent.V0(item, id);
        }
    }
}

