// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/api/core/v1"
)

// OpsGenieConfigApplyConfiguration represents a declarative configuration of the OpsGenieConfig type for use
// with apply.
type OpsGenieConfigApplyConfiguration struct {
	SendResolved *bool                                       `json:"sendResolved,omitempty"`
	APIKey       *v1.SecretKeySelector                       `json:"apiKey,omitempty"`
	APIURL       *string                                     `json:"apiURL,omitempty"`
	Message      *string                                     `json:"message,omitempty"`
	Description  *string                                     `json:"description,omitempty"`
	Source       *string                                     `json:"source,omitempty"`
	Tags         *string                                     `json:"tags,omitempty"`
	Note         *string                                     `json:"note,omitempty"`
	Priority     *string                                     `json:"priority,omitempty"`
	UpdateAlerts *bool                                       `json:"updateAlerts,omitempty"`
	Details      []KeyValueApplyConfiguration                `json:"details,omitempty"`
	Responders   []OpsGenieConfigResponderApplyConfiguration `json:"responders,omitempty"`
	HTTPConfig   *HTTPConfigApplyConfiguration               `json:"httpConfig,omitempty"`
	Entity       *string                                     `json:"entity,omitempty"`
	Actions      *string                                     `json:"actions,omitempty"`
}

// OpsGenieConfigApplyConfiguration constructs a declarative configuration of the OpsGenieConfig type for use with
// apply.
func OpsGenieConfig() *OpsGenieConfigApplyConfiguration {
	return &OpsGenieConfigApplyConfiguration{}
}

// WithSendResolved sets the SendResolved field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SendResolved field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithSendResolved(value bool) *OpsGenieConfigApplyConfiguration {
	b.SendResolved = &value
	return b
}

// WithAPIKey sets the APIKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIKey field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithAPIKey(value v1.SecretKeySelector) *OpsGenieConfigApplyConfiguration {
	b.APIKey = &value
	return b
}

// WithAPIURL sets the APIURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIURL field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithAPIURL(value string) *OpsGenieConfigApplyConfiguration {
	b.APIURL = &value
	return b
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithMessage(value string) *OpsGenieConfigApplyConfiguration {
	b.Message = &value
	return b
}

// WithDescription sets the Description field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Description field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithDescription(value string) *OpsGenieConfigApplyConfiguration {
	b.Description = &value
	return b
}

// WithSource sets the Source field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Source field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithSource(value string) *OpsGenieConfigApplyConfiguration {
	b.Source = &value
	return b
}

// WithTags sets the Tags field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Tags field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithTags(value string) *OpsGenieConfigApplyConfiguration {
	b.Tags = &value
	return b
}

// WithNote sets the Note field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Note field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithNote(value string) *OpsGenieConfigApplyConfiguration {
	b.Note = &value
	return b
}

// WithPriority sets the Priority field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Priority field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithPriority(value string) *OpsGenieConfigApplyConfiguration {
	b.Priority = &value
	return b
}

// WithUpdateAlerts sets the UpdateAlerts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UpdateAlerts field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithUpdateAlerts(value bool) *OpsGenieConfigApplyConfiguration {
	b.UpdateAlerts = &value
	return b
}

// WithDetails adds the given value to the Details field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Details field.
func (b *OpsGenieConfigApplyConfiguration) WithDetails(values ...*KeyValueApplyConfiguration) *OpsGenieConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDetails")
		}
		b.Details = append(b.Details, *values[i])
	}
	return b
}

// WithResponders adds the given value to the Responders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Responders field.
func (b *OpsGenieConfigApplyConfiguration) WithResponders(values ...*OpsGenieConfigResponderApplyConfiguration) *OpsGenieConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithResponders")
		}
		b.Responders = append(b.Responders, *values[i])
	}
	return b
}

// WithHTTPConfig sets the HTTPConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTPConfig field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithHTTPConfig(value *HTTPConfigApplyConfiguration) *OpsGenieConfigApplyConfiguration {
	b.HTTPConfig = value
	return b
}

// WithEntity sets the Entity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Entity field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithEntity(value string) *OpsGenieConfigApplyConfiguration {
	b.Entity = &value
	return b
}

// WithActions sets the Actions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Actions field is set to the value of the last call.
func (b *OpsGenieConfigApplyConfiguration) WithActions(value string) *OpsGenieConfigApplyConfiguration {
	b.Actions = &value
	return b
}
