/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NfoUtils {
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";

    private NfoUtils() {
        throw new IllegalAccessError();
    }

    public static void addPersonIdsAsChildren(Element element, Person person) {
        int tvdbId;
        String imdbId;
        int tmdbId = person.getIdAsInt("tmdb");
        if (tmdbId > 0) {
            Element id = element.getOwnerDocument().createElement("tmdbid");
            id.setTextContent(String.valueOf(tmdbId));
            element.appendChild(id);
        }
        if (StringUtils.isNotBlank((CharSequence)(imdbId = person.getIdAsString("imdb")))) {
            Element id = element.getOwnerDocument().createElement("imdbid");
            id.setTextContent(imdbId);
            element.appendChild(id);
        }
        if ((tvdbId = person.getIdAsInt("tvdb")) > 0) {
            Element id = element.getOwnerDocument().createElement("tvdbid");
            id.setTextContent(String.valueOf(tvdbId));
            element.appendChild(id);
        }
    }

    public static void addPersonIdsAsAttributes(Element element, Person person) {
        int tvdbId;
        String imdbId;
        int tmdbId = person.getIdAsInt("tmdb");
        if (tmdbId > 0) {
            element.setAttribute("tmdbid", String.valueOf(tmdbId));
        }
        if (StringUtils.isNotBlank((CharSequence)(imdbId = person.getIdAsString("imdb")))) {
            element.setAttribute("imdbid", imdbId);
        }
        if ((tvdbId = person.getIdAsInt("tvdb")) > 0) {
            element.setAttribute("tvdbid", String.valueOf(tvdbId));
        }
    }

    public static String detectDefaultScraper(MediaEntity mediaEntity) {
        if (mediaEntity.getIds().containsKey("imdb")) {
            return "imdb";
        }
        if (mediaEntity.getIds().containsKey("tvdb")) {
            return "tvdb";
        }
        if (mediaEntity.getIds().containsKey("tmdb")) {
            return "tmdb";
        }
        return mediaEntity.getIds().keySet().stream().findFirst().orElse("");
    }

    public static Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        try {
            transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }

    public static Element getSingleElementByTag(Document document, String tag) {
        NodeList nodeList = document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    private static String mapVideoCodecToNfo(String codec) {
        if (StringUtils.isBlank((CharSequence)codec)) {
            return "";
        }
        return switch (codec.toLowerCase()) {
            case "avc" -> "h264";
            case "h265" -> "hevc";
            case "mpeg-1" -> "mpeg1";
            case "mpeg-2" -> "mpeg2";
            case "mpeg-4" -> "mpeg4";
            default -> codec.toLowerCase();
        };
    }

    private static String mapAudioCodecToNfo(String codec) {
        if (StringUtils.isBlank((CharSequence)codec)) {
            return "";
        }
        return switch (codec.toLowerCase()) {
            case "ac3ex" -> "ac3";
            case "adpcm_ms" -> "pcm";
            case "dts", "dts-es", "dts-96/24" -> "dca";
            case "truehd/atmos" -> "truehd_atmos";
            case "dtshd-hra" -> "dtshd_hra";
            case "dtshd-ma" -> "dtshd_ma";
            case "dts-x" -> "dtshd_ma_x";
            case "dts-x-imax" -> "dtshd_ma_x_imax";
            case "eac3/atmos" -> "eac3_ddp_atmos";
            default -> codec.toLowerCase();
        };
    }

    private static String mapStereomode(String stereomode) {
        if (StringUtils.isBlank((CharSequence)stereomode)) {
            return "";
        }
        if (stereomode.equals("3D SBS") || stereomode.equals("3D HSBS")) {
            return "split_vertical";
        }
        if (stereomode.equals("3D TAB") || stereomode.equals("3D HTAB")) {
            return "split_horizontal";
        }
        return switch (stereomode.toLowerCase()) {
            case "left_right", "right_left" -> "split_vertical";
            case "checkerboard_rl", "checkerboard_lr" -> "checkerboard";
            case "top_bottom", "bottom_top" -> "split_horizontal";
            case "row_interleaved_rl", "row_interleaved_lr" -> "row_interleaved";
            case "col_interleaved_rl", "col_interleaved_lr", "block_lr", "block_rl" -> "off";
            default -> stereomode.toLowerCase();
        };
    }

    private static String mapVideoResolutionToNfo(String videoFormat) {
        if (StringUtils.isBlank((CharSequence)videoFormat)) {
            return "";
        }
        return switch (videoFormat.toLowerCase()) {
            case "2160p" -> "4K";
            case "4320p" -> "8K";
            default -> videoFormat.replace("p", "");
        };
    }

    public static Element createStreamdetailsVideoTag(Element parent, MediaFile mediaFile) {
        Document document = parent.getOwnerDocument();
        Element video = document.createElement("video");
        Element codec = document.createElement("codec");
        codec.setTextContent(NfoUtils.mapVideoCodecToNfo(mediaFile.getVideoCodec()));
        video.appendChild(codec);
        Element aspect = document.createElement("aspect");
        aspect.setTextContent(String.format(Locale.US, "%.2f", mediaFile.getAspectRatio()));
        video.appendChild(aspect);
        Element width = document.createElement("width");
        width.setTextContent(Integer.toString(mediaFile.getVideoWidth()));
        video.appendChild(width);
        Element height = document.createElement("height");
        height.setTextContent(Integer.toString(mediaFile.getVideoHeight()));
        video.appendChild(height);
        Element resolution = document.createElement("resolution");
        resolution.setTextContent(NfoUtils.mapVideoResolutionToNfo(mediaFile.getVideoFormat()));
        video.appendChild(resolution);
        if (StringUtils.isNotEmpty((CharSequence)mediaFile.getHdrFormat())) {
            String hdrFormat = mediaFile.getHdrFormat().toLowerCase();
            Element hdrtype = document.createElement("hdrtype");
            if (hdrFormat.contains("dolby vision")) {
                hdrtype.setTextContent("dolbyvision");
            } else if (hdrFormat.contains("hdr10+")) {
                hdrtype.setTextContent("hdr10plus");
            } else {
                hdrtype.setTextContent(hdrFormat);
            }
            video.appendChild(hdrtype);
        }
        if (!mediaFile.getVideo3DFormat().isEmpty()) {
            Element stereomode = document.createElement("stereomode");
            stereomode.setTextContent(NfoUtils.mapStereomode(mediaFile.getVideo3DFormat()));
            video.appendChild(stereomode);
        }
        return video;
    }

    public static Element createStreamdetailsAudioTag(Element parent, MediaFileAudioStream audioStream) {
        Document document = parent.getOwnerDocument();
        Element audio = document.createElement("audio");
        Element codec = document.createElement("codec");
        codec.setTextContent(NfoUtils.mapAudioCodecToNfo(audioStream.getCodec()));
        audio.appendChild(codec);
        Element language = document.createElement("language");
        language.setTextContent(LanguageUtils.parseLanguageFromString(audioStream.getLanguage()));
        audio.appendChild(language);
        Element channels = document.createElement("channels");
        channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
        audio.appendChild(channels);
        return audio;
    }
}

