/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.boolex;

import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluatorBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RequestURIEventEvaluator
extends EventEvaluatorBase<IAccessEvent> {
    String regex;
    private Pattern pattern;

    public void start() {
        if (this.regex == null) {
            this.addError("regex is required");
            return;
        }
        try {
            this.addInfo("Compiling pattern [" + this.regex + "]");
            this.pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            this.addError("Invalid regular expression: " + this.regex);
            return;
        }
        super.start();
    }

    public boolean evaluate(IAccessEvent iAccessEvent) throws NullPointerException, EvaluationException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Evaluator [" + String.valueOf((Object)this) + "] was called in stopped state");
        }
        String requestURI = iAccessEvent.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(requestURI);
        return matcher.find();
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

