/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.systemlog.device;

import com.ubnt.data.Site;
import com.ubnt.model.api.systemlog.device.ApLogListParameterDto;
import com.ubnt.model.api.systemlog.device.DeviceLogDto;
import com.ubnt.model.api.systemlog.device.DeviceLogDtoList;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.systemlog.device.DeviceLogScope;
import com.ubnt.service.alert.AlertDocument;
import com.ubnt.service.systemlog.device.O0OO;
import com.ubnt.service.systemlog.device.Object;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Device Log")
public class DeviceLogController {
    private final Object o00000;
    private final O0OO new;

    public DeviceLogController(Object object, O0OO o0OO2) {
        this.o00000 = object;
        this.new = o0OO2;
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/device/{deviceMac}"})
    @Operation(summary="List all device logs")
    public List<DeviceLogDto> listDeviceLogs(@PathVariable(value="siteName") Site site, @PathVariable(value="deviceMac") String string, @RequestParam(value="scope", defaultValue="DEVICE") DeviceLogScope deviceLogScope, @RequestParam(value="limit", defaultValue="5") @Min(value=1L) @Min(value=1L) int n2) {
        return this.new.super(this.o00000.Object(site.getId(), string, deviceLogScope, n2));
    }

    @Deprecated
    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/ap-logs"})
    @Operation(summary="List all AP logs")
    public DeviceLogDtoList listApLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid ApLogListParameterDto apLogListParameterDto) {
        return this.super(site, apLogListParameterDto);
    }

    private DeviceLogDtoList super(Site site, ApLogListParameterDto apLogListParameterDto) {
        Page<AlertDocument> page = this.o00000.\u00d600000(apLogListParameterDto.toSearchParameters(site.getId()));
        return DeviceLogDtoList.builder().totalPageCount(page.getTotalPages()).totalElementCount(page.getTotalElements()).pageNumber(page.getNumber()).data(this.new.super(page.getContent())).build();
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/ap-logs/display-options/aps"})
    @Operation(summary="List unique MAC addresses of APs for which we have logs")
    public List<String> getUniqueApMacsInApLogs(@PathVariable(value="siteName") Site site) {
        return this.o00000.o00000(site.getId());
    }
}

