/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.Messages;
import java.lang.reflect.Constructor;
import java.net.URL;

@Deprecated
public class ApplicationSecurityEnforcer {
    static final String EXCEPTION_NO_POLICY_FILE = "ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file";
    public static final String PROPERTY_APP_DEV_BASE = "app.dev.base";
    public static final String PROPERTY_APP_DEV_CLASS_DIR = "app.dev.classdir";
    public static final String PROPERTY_APP_DEV_TEST_CLASS_DIR = "app.dev.testdir";
    public static final String PROPERTY_IDE_CLASS_DIR = "app.ide.classdir";
    public static final String PROPERTY_APP_JAR_BASE = "app.jar.base";
    private final Class<?> appMainClass;
    private final String securityPolicy;

    ApplicationSecurityEnforcer(Class<?> appMainClass, String securityPolicy) {
        this.appMainClass = appMainClass;
        this.securityPolicy = securityPolicy;
    }

    public static ApplicationSecurityEnforcer createSecurityEnforcer(Class<?> appMainClass, String securityPolicy) {
        ApplicationSecurityEnforcer ase;
        try {
            Class<?> cl = Class.forName("io.sf.carte.echosvg.util.SMApplicationSecurityEnforcer");
            Constructor<?> ctor = cl.getConstructor(Class.class, String.class);
            ase = (ApplicationSecurityEnforcer)ctor.newInstance(appMainClass, securityPolicy);
        }
        catch (Exception e) {
            ase = new ApplicationSecurityEnforcer(appMainClass, securityPolicy);
        }
        return ase;
    }

    protected Class<?> getApplicationMainClass() {
        return this.appMainClass;
    }

    protected String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void enforceSecurity(boolean enforce) {
    }

    public URL getPolicyURL() {
        ClassLoader cl = this.appMainClass.getClassLoader();
        URL policyURL = cl.getResource(this.securityPolicy);
        if (policyURL == null) {
            throw new NullPointerException(Messages.formatMessage(EXCEPTION_NO_POLICY_FILE, new Object[]{this.securityPolicy}));
        }
        return policyURL;
    }

    public void installSecurityManager() {
    }
}

