/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.table;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.fibs.geotag.table.TextCellEditor;

public abstract class NavigableTable
extends JTable {
    private int editingCellAtRow = -1;
    private int editingCellAtColumn = -1;

    public NavigableTable() {
    }

    public NavigableTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public NavigableTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public NavigableTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public NavigableTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public NavigableTable(TableModel dm) {
        super(dm);
    }

    public NavigableTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
    }

    void scrollCellToVisible(int row, int column) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle cellRectangle = this.getCellRect(row, column, true);
        Point viewPosition = viewport.getViewPosition();
        cellRectangle.translate(-viewPosition.x, -viewPosition.y);
        viewport.scrollRectToVisible(cellRectangle);
    }

    private void moveEditorTo(int row, int column) {
        this.editCellAt(row, column);
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(column, column);
        ((DefaultCellEditor)this.getCellEditor()).getComponent().requestFocus();
        this.scrollCellToVisible(row, column);
    }

    public void navigateLeft(KeyEvent keyEvent) {
        int row = this.editingCellAtRow;
        int column = this.editingCellAtColumn;
        int offset = 1;
        while (offset <= this.getColumnCount()) {
            int nextColumn = column - offset;
            if (nextColumn < 0) {
                nextColumn += this.getColumnCount();
            }
            if (this.isCellEditable(row, nextColumn)) {
                this.moveEditorTo(row, nextColumn);
                break;
            }
            ++offset;
        }
    }

    public void navigateRight(KeyEvent keyEvent) {
        int row = this.editingCellAtRow;
        int column = this.editingCellAtColumn;
        int offset = 1;
        while (offset <= this.getColumnCount()) {
            int nextColumn = (column + offset) % this.getColumnCount();
            if (this.isCellEditable(row, nextColumn)) {
                this.moveEditorTo(row, nextColumn);
                break;
            }
            ++offset;
        }
    }

    public void navigateUp(KeyEvent keyEvent) {
        TableCellEditor currentEditor = this.getCellEditor();
        if (currentEditor == null) {
            if (this.getSelectedRowCount() == 1) {
                int selectedRow = this.getSelectedRow() - 1;
                if (selectedRow < 0) {
                    selectedRow = this.getRowCount() - 1;
                }
                this.changeSelection(selectedRow, selectedRow, false, false);
            }
        } else {
            int row = this.editingCellAtRow;
            int column = this.editingCellAtColumn;
            TextCellEditor editor = (TextCellEditor)((DefaultCellEditor)this.getCellEditor()).getComponent();
            String oldValue = editor.getText();
            int offset = 1;
            while (offset <= this.getRowCount()) {
                int nextRow = row - offset;
                if (nextRow < 0) {
                    nextRow += this.getRowCount();
                }
                if (this.isCellEditable(nextRow, column)) {
                    this.moveEditorTo(nextRow, column);
                    if ((keyEvent.getModifiersEx() & 0x40) != 64) break;
                    editor.setText(oldValue);
                    break;
                }
                ++offset;
            }
        }
    }

    public void navigateDown(KeyEvent keyEvent) {
        TableCellEditor currentEditor = this.getCellEditor();
        if (currentEditor == null) {
            if (this.getSelectedRowCount() == 1) {
                int selectedRow = (this.getSelectedRow() + 1) % this.getRowCount();
                this.changeSelection(selectedRow, selectedRow, false, false);
            }
        } else {
            int row = this.editingCellAtRow;
            int column = this.editingCellAtColumn;
            TextCellEditor editor = (TextCellEditor)((DefaultCellEditor)this.getCellEditor()).getComponent();
            String oldValue = editor.getText();
            int offset = 1;
            while (offset <= this.getRowCount()) {
                int nextRow = (row + offset) % this.getRowCount();
                if (this.isCellEditable(nextRow, column)) {
                    this.moveEditorTo(nextRow, column);
                    if ((keyEvent.getModifiersEx() & 0x40) != 64) break;
                    editor.setText(oldValue);
                    break;
                }
                ++offset;
            }
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (super.editCellAt(row, column, e)) {
            this.editingCellAtRow = row;
            this.editingCellAtColumn = column;
            return true;
        }
        return false;
    }
}

