/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo4_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("4.2.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo4_2_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel realm) {
        AtomicInteger priority = new AtomicInteger(10);
        realm.getRequiredActionProvidersStream().sorted(Comparator.comparing(RequiredActionProviderModel::getName)).forEachOrdered(model -> {
            LOG.debugf("Setting priority '%d' for required action '%s' in realm '%s'", priority.get(), (Object)model.getAlias(), (Object)realm.getName());
            model.setPriority(priority.get());
            priority.addAndGet(10);
            realm.updateRequiredActionProvider(model);
        });
    }
}

