/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericPrimitive;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.util.Utils;

public class PolicyConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID f = PKIX.T;
    private BigInteger g;
    private BigInteger h;

    public PolicyConstraintsExtension() {
        super(f);
    }

    public PolicyConstraintsExtension(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, false);
    }

    public PolicyConstraintsExtension(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
        super(f, bl);
        this.g = bigInteger;
        this.h = bigInteger2;
        this.a(this.g());
    }

    public PolicyConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public BigInteger e() {
        if (!this.e) {
            this.h();
        }
        return this.g;
    }

    public BigInteger f() {
        if (!this.e) {
            this.h();
        }
        return this.h;
    }

    private byte[] g() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.g != null) {
            aSN1Sequence.a(new ASN1GenericPrimitive(new ASN1Integer(this.g), 0));
        }
        if (this.h != null) {
            aSN1Sequence.a(new ASN1GenericPrimitive(new ASN1Integer(this.h), 1));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.e = true;
        return byArray;
    }

    private void h() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.d());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            if (aSN1SequenceInputStream.a() && aSN1SequenceInputStream.d() == 0) {
                aSN1SequenceInputStream.a(2);
                this.g = ASN1Integer.b(aSN1SequenceInputStream);
            } else {
                this.g = null;
            }
            if (aSN1SequenceInputStream.a() && aSN1SequenceInputStream.d() == 1) {
                aSN1SequenceInputStream.a(2);
                this.h = ASN1Integer.b(aSN1SequenceInputStream);
            } else {
                this.h = null;
            }
            if (this.g == null && this.h == null) {
                throw new ASN1FormatException("Malformed extension contents");
            }
            aSN1SequenceInputStream.b();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.e = true;
    }

    @Override
    public String toString() {
        if (!this.e) {
            this.h();
        }
        StringBuffer stringBuffer = new StringBuffer("policyConstraintsExtension {oid = " + f.d() + ", critical = " + this.c() + ", value = [");
        boolean bl = false;
        if (this.e() != null) {
            stringBuffer.append("requireExplicit = " + this.e());
            bl = true;
        }
        if (this.f() != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("inhibitMapping = " + this.f());
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

