/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementQuery;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    StatementResultUpdate() {
        this.writeTableNames = new HsqlNameManager.HsqlName[1];
        this.setCompileTimestamp(Long.MAX_VALUE);
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable throwable) {
            this.clearStructures(session);
            result = Result.newErrorResult(throwable);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        session.getTransactionUTC();
        this.checkAccessRights(session);
        Object[] objectArray = session.sessionContext.dynamicArguments;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        switch (this.actionType) {
            case 91: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] blArray = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    objectArray2[this.baseColumnMap[i]] = objectArray[i];
                    blArray[this.baseColumnMap[i]] = true;
                }
                this.updateColumnMap = ArrayUtil.booleanArrayToIntIndexes(blArray);
                rowSetNavigatorDataChange.addRow(session, row, objectArray2, this.baseTable.getColumnTypes(), this.updateColumnMap);
                rowSetNavigatorDataChange.endMainDataSet();
                this.update(session, this.baseTable, rowSetNavigatorDataChange, null);
                return this.updateNavigator(session, rowSetNavigatorDataChange);
            }
            case 18: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                rowSetNavigatorDataChange.addRow(row);
                rowSetNavigatorDataChange.endMainDataSet();
                this.delete(session, this.baseTable, rowSetNavigatorDataChange, null);
                return this.updateNavigator(session, rowSetNavigatorDataChange);
            }
            case 55: {
                Object[] objectArray3 = this.baseTable.getNewRowData(session);
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    objectArray3[this.baseColumnMap[i]] = objectArray[i];
                }
                return this.insertSingleRow(session, persistentStore, objectArray3);
            }
        }
        throw Error.runtimeError(201, "StatementResultUpdate");
    }

    Result updateNavigator(Session session, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        Object object;
        Object object2;
        HsqlArrayList<Object[]> hsqlArrayList = new HsqlArrayList<Object[]>();
        rowSetNavigatorDataChange.beforeFirst();
        while (rowSetNavigatorDataChange.next()) {
            Object[] objectArray;
            object2 = rowSetNavigatorDataChange.getCurrentRow();
            object = rowSetNavigatorDataChange.getUpdatedRow();
            if (((Row)object2).getTable() != this.baseTable) continue;
            long l = ((Row)object2).getId();
            Object[] objectArray2 = this.result.getNavigator().getData(l);
            if (objectArray2 == null) continue;
            if (object == null) {
                objectArray = new Object[objectArray2.length];
                objectArray[this.result.metaData.getColumnCount() + 0] = l;
                objectArray[this.result.metaData.getColumnCount() + 1] = 2;
                objectArray[this.result.metaData.getColumnCount() + 2] = objectArray2[this.result.metaData.getColumnCount() + 2];
            } else {
                objectArray = (Object[])ArrayUtil.duplicateArray(objectArray2);
                ArrayUtil.projectRowReverse(objectArray, this.baseColumnMap, ((Row)object).getData());
                objectArray[this.result.metaData.getColumnCount() + 1] = 1;
                long l2 = ((Row)object).getId();
                objectArray[this.result.metaData.getColumnCount() + 0] = l2;
                if (!this.baseTable.isFileBased()) {
                    objectArray[this.result.metaData.getColumnCount() + 3] = object;
                }
            }
            ((RowSetNavigatorData)this.result.getNavigator()).updateData(l, objectArray);
            hsqlArrayList.add(objectArray);
        }
        if (session.isNetwork) {
            object = new RowSetNavigatorData(session, hsqlArrayList);
            object2 = Result.newDataResult(this.result.metaData);
            ((Result)object2).setNavigator((RowSetNavigator)object);
        } else {
            object2 = Result.updateOneResult;
        }
        return object2;
    }

    long getRowId(Object[] objectArray) {
        int n = this.result.metaData.getColumnCount();
        int n2 = n + 0;
        long l = (Long)objectArray[n2];
        return l;
    }

    Object[] getData(long l) {
        return this.result.getNavigator().getData(l);
    }

    Row getRow(Session session, Object[] objectArray) {
        int n = this.result.metaData.getColumnCount();
        long l = this.getRowId(objectArray);
        Row row = null;
        if (this.baseTable.isFileBased()) {
            PersistentStore persistentStore = this.baseTable.getRowStore(session);
            long l2 = l & 0xFFFFFFFFFFL;
            row = (Row)persistentStore.get(l2, false);
        } else {
            Object[] objectArray2 = this.getData(l);
            if (objectArray2 != null) {
                row = (Row)objectArray2[n + 3];
            }
        }
        return row;
    }

    void setRowActionProperties(Result result, int n, StatementQuery statementQuery, Type[] typeArray) {
        QueryExpression queryExpression = statementQuery.queryExpression;
        this.result = result;
        this.actionType = n;
        this.baseTable = queryExpression.getBaseTable();
        this.types = typeArray;
        this.baseColumnMap = queryExpression.getBaseTableColumnMap();
        this.writeTableNames[0] = this.baseTable.getName();
        this.rangeVariables = queryExpression.getRangeVariables();
        this.targetRangeVariables = queryExpression.getRangeVariables();
        this.sql = statementQuery.getSQL();
        this.parameterMetaData = queryExpression.getMetaData();
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 10: {
                break;
            }
            case 55: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 44: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 92: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 56: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

