/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.index.Index;
import org.opensearch.core.rest.RestStatus;

public class RestUtils {
    public static void validateSparseIndices(Index[] indices, ClusterService clusterService, String apiOperation) {
        List invalidIndexNames = Arrays.stream(indices).filter(index -> {
            String sparseIndexSetting = Optional.ofNullable(clusterService).map(ClusterService::state).map(ClusterState::metadata).map(metadata -> metadata.getIndexSafe(index)).map(IndexMetadata::getSettings).map(settings -> settings.get("index.sparse")).orElse(null);
            return !"true".equals(sparseIndexSetting);
        }).map(Index::getName).collect(Collectors.toList());
        if (!invalidIndexNames.isEmpty()) {
            throw new OpenSearchStatusException(String.format(Locale.ROOT, "Request rejected. Indices [%s] don't support %s operation.", String.join((CharSequence)", ", invalidIndexNames), apiOperation), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }
}

