/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;

final class FBCachedFetcher
implements FBFetcher {
    private final boolean forwardOnly;
    private List<RowValue> rows;
    private int rowNum;
    private int fetchSize;
    private FBObjectListener.FetcherListener fetcherListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBCachedFetcher(GDSHelper gdsHelper, int fetchSize, int maxRows, FbStatement stmt_handle, FBObjectListener.FetcherListener fetcherListener, boolean forwardOnly) throws SQLException {
        this.fetcherListener = fetcherListener;
        this.forwardOnly = forwardOnly;
        RowDescriptor rowDescriptor = stmt_handle.getRowDescriptor();
        boolean[] isBlob = new boolean[rowDescriptor.getCount()];
        boolean hasBlobs = FBCachedFetcher.determineBlobs(rowDescriptor, isBlob);
        this.fetchSize = fetchSize != 0 ? fetchSize : 400;
        try {
            RowListener rowListener = new RowListener();
            stmt_handle.addStatementListener(rowListener);
            try {
                int actualFetchSize = this.getFetchSize();
                while (!(rowListener.isAllRowsFetched() || maxRows != 0 && rowListener.size() >= maxRows)) {
                    if (maxRows > 0) {
                        actualFetchSize = Math.min(actualFetchSize, maxRows - rowListener.size());
                    }
                    assert (actualFetchSize > 0) : "actualFetchSize should be > 0";
                    stmt_handle.fetchRows(actualFetchSize);
                }
                this.rows = rowListener.getRows();
            }
            finally {
                stmt_handle.removeStatementListener(rowListener);
            }
            if (hasBlobs) {
                for (RowValue row : this.rows) {
                    FBCachedFetcher.cacheBlobsInRow(gdsHelper, rowDescriptor, isBlob, row);
                }
            }
        }
        finally {
            stmt_handle.closeCursor();
        }
    }

    FBCachedFetcher(List<RowValue> rows, FBObjectListener.FetcherListener fetcherListener, RowDescriptor rowDescriptor, GDSHelper gdsHelper, boolean retrieveBlobs) throws SQLException {
        boolean[] isBlob;
        boolean hasBlobs;
        assert (!retrieveBlobs || rowDescriptor != null && gdsHelper != null) : "Need non-null rowDescriptor and gdsHelper for retrieving blobs";
        this.rows = new ArrayList<RowValue>(rows);
        this.fetcherListener = fetcherListener;
        this.forwardOnly = false;
        if (retrieveBlobs && (hasBlobs = FBCachedFetcher.determineBlobs(rowDescriptor, isBlob = new boolean[rowDescriptor.getCount()]))) {
            for (RowValue row : rows) {
                FBCachedFetcher.cacheBlobsInRow(gdsHelper, rowDescriptor, isBlob, row);
            }
        }
    }

    private static boolean determineBlobs(RowDescriptor rowDescriptor, boolean[] isBlob) {
        assert (rowDescriptor.getCount() == isBlob.length) : "length of isBlob should be equal to length of rowDescriptor";
        boolean hasBlobs = false;
        for (int i = 0; i < rowDescriptor.getCount(); ++i) {
            FieldDescriptor field = rowDescriptor.getFieldDescriptor(i);
            boolean bl = isBlob[i] = JdbcTypeConverter.isJdbcType(field, 2004) || JdbcTypeConverter.isJdbcType(field, -4) || JdbcTypeConverter.isJdbcType(field, -1);
            if (!isBlob[i]) continue;
            hasBlobs = true;
        }
        return hasBlobs;
    }

    private static void cacheBlobsInRow(GDSHelper gdsHelper, RowDescriptor rowDescriptor, boolean[] isBlob, RowValue localRow) throws SQLException {
        for (int j = 0; j < localRow.getCount(); ++j) {
            final byte[] tempData = localRow.getFieldData(j);
            if (!isBlob[j] || tempData == null) continue;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return tempData;
                }

                @Override
                public void setFieldData(byte[] data) {
                    throw new UnsupportedOperationException();
                }
            };
            FBFlushableField blob = (FBFlushableField)((Object)FBField.createField(rowDescriptor.getFieldDescriptor(j), dataProvider, gdsHelper, false));
            localRow.setFieldData(j, blob.getCachedData());
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        ++this.rowNum;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rows.size() + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, this.rows.get(this.rowNum - 1));
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScrollable();
        if (this.isEmpty()) {
            return false;
        }
        --this.rowNum;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        this.fetcherListener.rowChanged(this, this.rows.get(this.rowNum - 1));
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.absolute(row, false);
    }

    private boolean absolute(int row, boolean internal) throws SQLException {
        this.checkScrollable();
        if (row < 0) {
            row = this.rows.size() + row + 1;
        }
        if (this.isEmpty()) {
            return false;
        }
        this.rowNum = row;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rows.size() + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, this.rows.get(this.rowNum - 1));
        return true;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1, true);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1, true);
    }

    @Override
    public boolean relative(int row) throws SQLException {
        return this.absolute(this.rowNum + row, true);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.rows = Collections.emptyList();
        this.fetcherListener = null;
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.rowNum < 1;
    }

    @Override
    public boolean isFirst() {
        return this.rowNum == 1;
    }

    @Override
    public boolean isLast() {
        return this.rows != null && this.rowNum == this.rows.size();
    }

    @Override
    public boolean isAfterLast() {
        return this.rowNum > this.rows.size();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.rows.remove(this.rowNum - 1);
        this.fetcherListener.rowChanged(this, this.isAfterLast() || this.isBeforeFirst() ? null : this.rows.get(this.rowNum - 1));
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
        if (this.rowNum == 0) {
            this.rowNum = 1;
        }
        if (this.rowNum > this.rows.size()) {
            this.rows.add(data);
        } else {
            this.rows.add(this.rowNum - 1, data);
        }
        this.fetcherListener.rowChanged(this, this.isAfterLast() || this.isBeforeFirst() ? null : this.rows.get(this.rowNum - 1));
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
        if (!this.isAfterLast() && !this.isBeforeFirst()) {
            this.rows.set(this.rowNum - 1, data);
            this.fetcherListener.rowChanged(this, data);
        }
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int currentPosition() {
        return this.rowNum;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public void setFetcherListener(FBObjectListener.FetcherListener fetcherListener) {
        this.fetcherListener = fetcherListener;
    }

    private void checkScrollable() throws SQLException {
        if (this.forwardOnly) {
            throw new FbExceptionBuilder().nonTransientException(337248279).toSQLException();
        }
    }

    private static final class RowListener
    implements StatementListener {
        private final List<RowValue> rows = new ArrayList<RowValue>();
        private boolean allRowsFetched = false;

        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.allRowsFetched = true;
        }

        public boolean isAllRowsFetched() {
            return this.allRowsFetched;
        }

        public List<RowValue> getRows() {
            return this.rows;
        }

        public int size() {
            return this.rows.size();
        }
    }
}

