-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS INDEX_CATALOG,
  INDEXES.OWNER AS INDEX_SCHEMA,
  INDEXES.INDEX_NAME AS INDEX_NAME,
  INDEXES.TABLE_NAME AS TABLE_NAME,
  DBMS_METADATA.GET_DDL('INDEX', INDEXES.INDEX_NAME, INDEXES.OWNER)
    AS INDEX_DEFINITION,
  INDEXES.COMPRESSION,
  INDEXES.TABLESPACE_NAME
FROM
  ${catalogscope}_INDEXES INDEXES
  INNER JOIN ${catalogscope}_USERS USERS
    ON INDEXES.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  REGEXP_LIKE(INDEXES.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(INDEXES.OWNER || '.' || INDEXES.TABLE_NAME, '${table-inclusion-rule}')
  AND INDEXES.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(INDEXES.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
ORDER BY
  INDEX_SCHEMA,
  TABLE_NAME,
  INDEX_NAME
