// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const findNodeUpToRoot = require('./findNodeUpToRoot.cjs');
const typeGuards = require('./typeGuards.cjs');
const atKeywords = require('../reference/atKeywords.cjs');

/** @import { Declaration, Node } from 'postcss' */

/**
 * Check whether a declaration is a descriptor one
 *
 * @param {Declaration} decl
 * @returns {boolean}
 */
function isDescriptorDeclaration(decl) {
	return Boolean(findNodeUpToRoot(decl, isAtRuleSupportingDescriptors));
}

/**
 * @param {Node} node
 */
function isAtRuleSupportingDescriptors(node) {
	return typeGuards.isAtRule(node) && !atKeywords.nestingSupportedAtKeywords.has(node.name.toLowerCase());
}

module.exports = isDescriptorDeclaration;
