/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.level.ServerPlayer;

public class PlayerService {
    private static final Component DEFAULT_KICK_MESSAGE = Component.translatable("multiplayer.disconnect.kicked");

    public static List<PlayerDto> get(MinecraftApi $$0) {
        return $$0.playerListService().getPlayers().stream().map(PlayerDto::from).toList();
    }

    public static List<PlayerDto> kick(MinecraftApi $$0, List<KickDto> $$1, ClientInfo $$2) {
        ArrayList<PlayerDto> $$3 = new ArrayList<PlayerDto>();
        for (KickDto $$4 : $$1) {
            ServerPlayer $$5 = PlayerService.getServerPlayer($$0, $$4.player());
            if ($$5 == null) continue;
            $$0.playerListService().remove($$5, $$2);
            $$5.connection.disconnect($$4.message.flatMap(Message::asComponent).orElse(DEFAULT_KICK_MESSAGE));
            $$3.add($$4.player());
        }
        return $$3;
    }

    @Nullable
    private static ServerPlayer getServerPlayer(MinecraftApi $$0, PlayerDto $$1) {
        if ($$1.id().isPresent()) {
            return $$0.playerListService().getPlayer($$1.id().get());
        }
        if ($$1.name().isPresent()) {
            return $$0.playerListService().getPlayerByName($$1.name().get());
        }
        return null;
    }

    public record KickDto(PlayerDto player, Optional<Message> message) {
        public static final MapCodec<KickDto> CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(KickDto::player), (App)Message.CODEC.optionalFieldOf("message").forGetter(KickDto::message)).apply((Applicative)$$0, KickDto::new));
    }
}

