/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class TypedEntityData<IdType>
implements TooltipProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TYPE_TAG = "id";
    final IdType type;
    final CompoundTag tag;

    public static <T> Codec<TypedEntityData<T>> codec(final Codec<T> $$0) {
        return new Codec<TypedEntityData<T>>(){

            public <V> DataResult<Pair<TypedEntityData<T>, V>> decode(DynamicOps<V> $$02, V $$12) {
                DataResult $$22 = $$02.get($$12, TypedEntityData.TYPE_TAG).flatMap($$2 -> $$0.parse($$02, $$2).mapError($$0 -> "Failed to parse 'id': " + $$0));
                DataResult $$3 = CustomData.COMPOUND_TAG_CODEC.decode($$02, $$02.remove($$12, TypedEntityData.TYPE_TAG));
                return $$22.apply2stable(($$0, $$1) -> new Pair(new TypedEntityData<Object>($$0, (CompoundTag)$$1.getFirst()), $$1.getSecond()), $$3);
            }

            public <V> DataResult<V> encode(TypedEntityData<T> $$02, DynamicOps<V> $$1, V $$2) {
                return $$0.encodeStart(1.asNbtOps($$1), $$02.type).flatMap($$3 -> {
                    CompoundTag $$4 = $$02.tag.copy();
                    $$4.put(TypedEntityData.TYPE_TAG, (Tag)$$3);
                    return CustomData.COMPOUND_TAG_CODEC.encode((Object)$$4, $$1, $$2);
                });
            }

            private static <T> DynamicOps<Tag> asNbtOps(DynamicOps<T> $$02) {
                if ($$02 instanceof RegistryOps) {
                    RegistryOps $$1 = (RegistryOps)$$02;
                    return $$1.withParent(NbtOps.INSTANCE);
                }
                return NbtOps.INSTANCE;
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((TypedEntityData)object, dynamicOps, object2);
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, TypedEntityData<T>> streamCodec(StreamCodec<B, T> $$0) {
        return StreamCodec.composite($$0, TypedEntityData::type, ByteBufCodecs.COMPOUND_TAG, TypedEntityData::tag, TypedEntityData::new);
    }

    TypedEntityData(IdType $$0, CompoundTag $$1) {
        this.type = $$0;
        this.tag = TypedEntityData.stripId($$1);
    }

    public static <T> TypedEntityData<T> of(T $$0, CompoundTag $$1) {
        return new TypedEntityData<T>($$0, $$1);
    }

    private static CompoundTag stripId(CompoundTag $$0) {
        if ($$0.contains(TYPE_TAG)) {
            CompoundTag $$1 = $$0.copy();
            $$1.remove(TYPE_TAG);
            return $$1;
        }
        return $$0;
    }

    public IdType type() {
        return this.type;
    }

    public boolean contains(String $$0) {
        return this.tag.contains($$0);
    }

    public boolean equals(Object $$0) {
        if ($$0 == this) {
            return true;
        }
        if ($$0 instanceof TypedEntityData) {
            TypedEntityData $$1 = (TypedEntityData)$$0;
            return this.type == $$1.type && this.tag.equals($$1.tag);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.tag.hashCode();
    }

    public String toString() {
        return String.valueOf(this.type) + " " + String.valueOf(this.tag);
    }

    public void loadInto(Entity $$0) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector($$0.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, $$0.registryAccess());
            $$0.saveWithoutId($$2);
            CompoundTag $$3 = $$2.buildResult();
            UUID $$4 = $$0.getUUID();
            $$3.merge(this.getUnsafe());
            $$0.load(TagValueInput.create((ProblemReporter)$$1, (HolderLookup.Provider)$$0.registryAccess(), $$3));
            $$0.setUUID($$4);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean loadInto(BlockEntity $$0, HolderLookup.Provider $$1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompoundTag tag() {
        return this.tag;
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }

    public CompoundTag copyTagWithoutId() {
        return this.tag.copy();
    }

    @Override
    public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2, DataComponentGetter $$3) {
        if (this.type.getClass() == EntityType.class) {
            EntityType $$4 = (EntityType)this.type;
            if ($$0.isPeaceful() && !$$4.isAllowedInPeaceful()) {
                $$1.accept(Component.translatable("item.spawn_egg.peaceful").withStyle(ChatFormatting.RED));
            }
        }
    }

    private static /* synthetic */ String lambda$loadInto$0() {
        return "(rollback)";
    }
}

