/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.dvd;

import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tinymediamanager.library.dvd.DvdAudioAttributes;
import org.tinymediamanager.library.dvd.DvdSubtitleAttributes;
import org.tinymediamanager.library.dvd.DvdTitleSet;
import org.tinymediamanager.library.dvd.IfoException;

public class IfoObjectReader {
    private static final long DVD_BLOCK_LENGTH = 2048L;
    private byte[] contents = null;
    private int currentPos = 0;

    public IfoObjectReader(byte[] byArray) {
        this.contents = byArray;
    }

    public IfoObjectReader(Path path) throws IOException {
        this.contents = Files.readAllBytes(path);
    }

    public IfoObjectReader at(long l) throws IOException {
        if (l >= (long)this.contents.length) {
            throw new EOFException();
        }
        this.currentPos = (int)l;
        return this;
    }

    public IfoObjectReader skip(int n) throws IOException {
        this.currentPos += n;
        if (this.currentPos > this.contents.length) {
            throw new EOFException();
        }
        return this;
    }

    public byte[] readFixedBytes(int n) throws IOException {
        byte[] byArray = Arrays.copyOfRange(this.contents, this.currentPos, this.currentPos + n);
        this.currentPos += n;
        return byArray;
    }

    public String readFixedString(int n) throws IOException {
        byte[] byArray = this.readFixedBytes(n);
        if (byArray[0] == 0) {
            return null;
        }
        return new String(byArray, "ASCII");
    }

    public int readu8() throws IOException {
        byte[] byArray = this.readFixedBytes(1);
        return byArray[0] & 0xFF;
    }

    public int readu16() throws IOException {
        byte[] byArray = this.readFixedBytes(2);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public long readu32() throws IOException {
        byte[] byArray = this.readFixedBytes(4);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public long readOffset() throws IOException {
        return this.readu32() * 2048L;
    }

    public long readBcdTimeMs() throws IOException {
        double d;
        byte[] byArray = this.readFixedBytes(4);
        switch (byArray[3] & 0xC0) {
            case 64: {
                d = 25.0;
                break;
            }
            case 192: {
                d = 29.97;
                break;
            }
            default: {
                throw new IfoException("Unknown fps rate: " + ((byArray[3] & 0xC0) >> 6));
            }
        }
        int n = ((byArray[3] & 0x30) >> 4) * 10 + (byArray[3] & 0xF);
        int n2 = ((byArray[2] & 0xF0) >> 4) * 10 + (byArray[2] & 0xF);
        int n3 = ((byArray[1] & 0xF0) >> 4) * 10 + (byArray[1] & 0xF);
        int n4 = ((byArray[0] & 0xF0) >> 4) * 10 + (byArray[0] & 0xF);
        double d2 = (double)((n4 * 60 + n3) * 60 + n2) * d + (double)n;
        return (long)(d2 * 1000.0 / d);
    }

    public Map<Integer, Long> readPgcOffsets() throws IOException {
        int n;
        long l = this.at(200L).readOffset();
        long l2 = this.readOffset();
        this.at(l);
        int n2 = this.readu16();
        if (n2 > 256) {
            throw new IfoException("Too many titles in ptt_srpt: " + n2);
        }
        this.skip(6);
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = this.readu32() + l;
        }
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = this.at(lArray[n]).readu16();
        }
        this.at(l2);
        n = this.readu16();
        this.skip(6);
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i] - 1;
            if (n3 >= n) {
                throw new IfoException("PGCI index out of range: " + n3 + " > " + n);
            }
            this.at(l2 + 8L + (long)(8 * n3));
            int n4 = this.readu8() & 0x7F;
            this.skip(3);
            long l3 = this.readu32() + l2;
            if (hashMap.containsKey(n4)) {
                throw new IfoException("Title " + n4 + " defined twice in PGC offset table");
            }
            hashMap.put(n4, l3);
        }
        return hashMap;
    }

    public DvdAudioAttributes readAudioAttributes() throws IOException {
        DvdAudioAttributes dvdAudioAttributes = new DvdAudioAttributes();
        int n = this.readu8();
        switch (n & 0xE0) {
            case 0: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.AC3);
                break;
            }
            case 64: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.MPEG1);
                break;
            }
            case 96: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.MPEG2);
                break;
            }
            case 128: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.LPCM);
                break;
            }
            case 160: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.SDDS);
                break;
            }
            case 192: {
                dvdAudioAttributes.setMode(DvdAudioAttributes.Mode.DTS);
            }
        }
        int n2 = this.readu8();
        dvdAudioAttributes.setChannels((n2 & 7) + 1);
        if ((n & 0xC) != 0) {
            dvdAudioAttributes.setLang(this.readFixedString(2));
        } else {
            this.skip(2);
        }
        int n3 = this.skip(1).readu8();
        switch (n3) {
            case 1: {
                dvdAudioAttributes.setType(DvdAudioAttributes.Type.NORMAL);
                break;
            }
            case 2: {
                dvdAudioAttributes.setType(DvdAudioAttributes.Type.VISUALLY_IMPAIRED);
                break;
            }
            case 3: {
                dvdAudioAttributes.setType(DvdAudioAttributes.Type.DIRECTORS_COMMENT);
                break;
            }
            case 4: {
                dvdAudioAttributes.setType(DvdAudioAttributes.Type.ALTERNATE);
            }
        }
        this.skip(2);
        return dvdAudioAttributes;
    }

    public DvdSubtitleAttributes readSubtitleAttributes() throws IOException {
        DvdSubtitleAttributes dvdSubtitleAttributes = new DvdSubtitleAttributes();
        int n = this.readu8();
        this.skip(1);
        if ((n & 3) != 0) {
            dvdSubtitleAttributes.setLanguage(this.readFixedString(2));
        } else {
            this.skip(2);
        }
        int n2 = this.skip(1).readu8();
        switch (n2) {
            case 1: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.NORMAL);
                break;
            }
            case 2: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.LARGE);
                break;
            }
            case 3: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.CHILDREN);
                break;
            }
            case 5: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.NORMAL_CAPTIONS);
                break;
            }
            case 6: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.LARGE_CAPTIONS);
                break;
            }
            case 7: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.CHILDREN_CAPTIONS);
                break;
            }
            case 9: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.FORCED);
                break;
            }
            case 13: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.DIRECTOR_COMMENTS);
                break;
            }
            case 14: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.LARGE_DIRECTOR_COMMENTS);
                break;
            }
            case 15: {
                dvdSubtitleAttributes.setType(DvdSubtitleAttributes.SubType.CHILDREN_DIRECTOR_COMMENTS);
            }
        }
        return dvdSubtitleAttributes;
    }

    public DvdTitleSet readTitleSet() throws IOException {
        int n;
        DvdTitleSet dvdTitleSet = new DvdTitleSet();
        int n2 = this.at(512L).readu8();
        boolean bl = (n2 & 0x30) != 0;
        dvdTitleSet.setFormat(bl ? DvdTitleSet.Format.PAL : DvdTitleSet.Format.NTSC);
        dvdTitleSet.setAspect((n2 & 0xC) == 12 ? DvdTitleSet.Aspect.ASPECT_16_9 : DvdTitleSet.Aspect.ASPECT_4_3);
        dvdTitleSet.setLetterboxEnabled((n2 & 1) == 0);
        dvdTitleSet.setPanScanEnabled((n2 & 2) == 0);
        int n3 = this.readu8();
        switch (n3 & 0x38) {
            case 0: {
                dvdTitleSet.setWidth(720);
                dvdTitleSet.setHeight(bl ? 576 : 480);
                break;
            }
            case 8: {
                dvdTitleSet.setWidth(704);
                dvdTitleSet.setHeight(bl ? 576 : 480);
                break;
            }
            case 16: {
                dvdTitleSet.setWidth(352);
                dvdTitleSet.setHeight(bl ? 576 : 480);
                break;
            }
            case 24: {
                dvdTitleSet.setWidth(352);
                dvdTitleSet.setHeight(bl ? 288 : 240);
            }
        }
        int n4 = this.readu16();
        for (n = 0; n < 8; ++n) {
            if (n < n4) {
                dvdTitleSet.getAudioAttributes().add(this.readAudioAttributes());
                continue;
            }
            this.skip(8);
        }
        this.skip(16);
        n = this.readu16();
        for (int i = 0; i < 32; ++i) {
            if (i < n) {
                dvdTitleSet.getSubAttributes().add(this.readSubtitleAttributes());
                continue;
            }
            this.skip(6);
        }
        return dvdTitleSet;
    }
}

