/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;

public final class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "java_vm";
    protected static boolean _isWindows;
    protected static boolean _isMacOS;
    protected static boolean _isLinux;

    public static boolean updateVersionAndRelaunch(File appdir, String getdownJarName, String newVersion, String javaLocalDir) throws IOException {
        File vfile = new File(appdir, "version.txt");
        try (PrintStream ps = new PrintStream(new FileOutputStream(vfile));){
            ps.println(newVersion);
        }
        File pro = new File(appdir, getdownJarName);
        if (LaunchUtil.mustMonitorChildren() || !pro.exists()) {
            return false;
        }
        String javaDir = StringUtil.isBlank(javaLocalDir) ? LOCAL_JAVA_DIR : javaLocalDir;
        String javaBin = LaunchUtil.getJVMBinaryPath(new File(appdir, javaDir), false);
        Object[] args = new String[]{javaBin, "-jar", pro.toString(), appdir.getPath()};
        Log.log.info("Running " + StringUtil.join(args, "\n  "), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])args, null);
            return true;
        }
        catch (IOException ioe) {
            Log.log.warning("Failed to run getdown", ioe);
            return false;
        }
    }

    public static String getJVMBinaryPath(File javaLocalDir, boolean windebug) {
        String vmpath = LaunchUtil.checkJVMPath(javaLocalDir.getAbsolutePath(), windebug);
        if (vmpath == null) {
            vmpath = LaunchUtil.checkJVMPath(System.getProperty("java.home"), windebug);
        }
        if (vmpath == null) {
            Log.log.warning("Unable to find java [local=" + javaLocalDir + ", java.home=" + System.getProperty("java.home") + "]!", new Object[0]);
            vmpath = "java";
        }
        if (LaunchUtil.isMacOS()) {
            try {
                File localVM = new File("/usr/bin/java").getCanonicalFile();
                if (localVM.equals(new File(vmpath).getCanonicalFile())) {
                    vmpath = "/usr/bin/java";
                }
            }
            catch (IOException ioe) {
                Log.log.warning("Failed to check Mac OS canonical VM path.", ioe);
            }
        }
        return vmpath;
    }

    public static void upgradeGetdown(File oldgd, File curgd, File newgd) {
        if (!newgd.exists() || newgd.length() == curgd.length()) {
            return;
        }
        Log.log.info("Updating Getdown with " + newgd + "...", new Object[0]);
        if (oldgd.exists()) {
            FileUtil.deleteHarder(oldgd);
        }
        if (!curgd.exists() || curgd.renameTo(oldgd)) {
            if (newgd.renameTo(curgd)) {
                FileUtil.deleteHarder(oldgd);
                try {
                    FileUtil.copy(curgd, newgd);
                }
                catch (IOException e) {
                    Log.log.warning("Error copying updated Getdown back: " + e, new Object[0]);
                }
                return;
            }
            Log.log.warning("Unable to renameTo(" + oldgd + ").", new Object[0]);
            if (!oldgd.renameTo(curgd)) {
                Log.log.warning("Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info("Attempting to upgrade by copying over " + curgd + "...", new Object[0]);
        try {
            FileUtil.copy(newgd, curgd);
        }
        catch (IOException ioe) {
            Log.log.warning("Mayday! Brute force copy method also failed.", ioe);
        }
    }

    public static boolean mustMonitorChildren() {
        String osname = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return osname.contains("windows 98") || osname.contains("windows me");
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isMacOS() {
        return _isMacOS;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    protected static String checkJVMPath(String vmhome, boolean windebug) {
        String vmbase = vmhome + File.separator + "bin" + File.separator;
        String vmpath = vmbase + "java";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        if (!windebug && new File(vmpath = vmbase + "javaw.exe").exists()) {
            return vmpath;
        }
        vmpath = vmbase + "java.exe";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        return null;
    }

    static {
        try {
            String osname = System.getProperty("os.name");
            osname = osname == null ? "" : osname;
            _isWindows = osname.contains("Windows");
            _isMacOS = osname.contains("Mac OS") || osname.contains("MacOS");
            _isLinux = osname.contains("Linux");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

