/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.ListSingleSourcePathsImpl;
import org.jgrapht.graph.GraphWalk;

abstract class BaseShortestPathAlgorithm<V, E>
implements ShortestPathAlgorithm<V, E> {
    protected final Graph<V, E> graph;

    public BaseShortestPathAlgorithm(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph is null");
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("graph must contain the source vertex");
        }
        HashMap paths = new HashMap();
        for (V v : this.graph.vertexSet()) {
            paths.put(v, this.getPath(source, v));
        }
        return new ListSingleSourcePathsImpl<V, E>(this.graph, source, paths);
    }

    @Override
    public double getPathWeight(V source, V sink) {
        GraphPath p = this.getPath(source, sink);
        if (p == null) {
            return Double.POSITIVE_INFINITY;
        }
        return p.getWeight();
    }

    protected final GraphPath<V, E> createEmptyPath(V source, V sink) {
        if (source.equals(sink)) {
            return new GraphWalk<V, E>(this.graph, source, sink, Collections.singletonList(source), Collections.emptyList(), 0.0);
        }
        return null;
    }
}

