/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.utils.OffsetUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "getEvaluatedConstTracker", "()Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "findConstantValueFor", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "firExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Companion", "fir2ir"})
public final class ConstValueProviderImpl
extends ConstValueProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final EvaluatedConstTracker evaluatedConstTracker;

    public ConstValueProviderImpl(@NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.session = components.getSession();
        this.evaluatedConstTracker = components.getConfiguration().getEvaluatedConstTracker();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public EvaluatedConstTracker getEvaluatedConstTracker() {
        return this.evaluatedConstTracker;
    }

    @Override
    @Nullable
    public ConstantValue<?> findConstantValueFor(@Nullable FirExpression firExpression) {
        FirFile firFile = this.getProcessingFirFile();
        if (firExpression == null || firFile == null) {
            return null;
        }
        if (firExpression instanceof FirVarargArgumentsExpression) {
            return null;
        }
        Pair<Integer, Integer> pair = Companion.getCorrespondingIrOffset(firExpression);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int start2 = ((Number)pair2.component1()).intValue();
        int end = ((Number)pair2.component2()).intValue();
        return this.getEvaluatedConstTracker().load(start2, end, (EvaluatedConstTracker.Key)firFile.getSymbol());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005*\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl$Companion;", "", "<init>", "()V", "getCorrespondingIrOffset", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pair<Integer, Integer> getCorrespondingIrOffset(@NotNull FirExpression $this$getCorrespondingIrOffset) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)$this$getCorrespondingIrOffset, (String)"<this>");
            if ($this$getCorrespondingIrOffset instanceof FirQualifiedAccessExpression && OffsetUtilsKt.shouldUseCalleeReferenceAsItsSourceInIr((FirQualifiedAccessExpression)$this$getCorrespondingIrOffset)) {
                int n;
                FirReference calleeReference = ((FirQualifiedAccessExpression)$this$getCorrespondingIrOffset).getCalleeReference();
                Object object = calleeReference.getSource();
                if (object != null && (object = OffsetUtilsKt.startOffsetSkippingComments$default((AbstractKtSourceElement)object, null, 1, null)) != null) {
                    n = (Integer)object;
                } else {
                    KtSourceElement ktSourceElement = calleeReference.getSource();
                    n = ktSourceElement != null ? ktSourceElement.getStartOffset() : -1;
                }
                int start2 = n;
                KtSourceElement ktSourceElement = ((FirQualifiedAccessExpression)$this$getCorrespondingIrOffset).getSource();
                if (ktSourceElement == null) {
                    return null;
                }
                int end = ktSourceElement.getEndOffset();
                pair = TuplesKt.to((Object)start2, (Object)end);
            } else {
                KtSourceElement ktSourceElement = $this$getCorrespondingIrOffset.getSource();
                if (ktSourceElement == null) {
                    return null;
                }
                int start3 = ktSourceElement.getStartOffset();
                KtSourceElement ktSourceElement2 = $this$getCorrespondingIrOffset.getSource();
                if (ktSourceElement2 == null) {
                    return null;
                }
                int end = ktSourceElement2.getEndOffset();
                pair = TuplesKt.to((Object)start3, (Object)end);
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

