/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.KotlinJavaMPPSourceSetDataService;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"getScopeContainingBoth", "Lcom/intellij/openapi/roots/DependencyScope;", "scope1", "scope2", "addModuleDependencyIfNeeded", "", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "dependeeModule", "Lcom/intellij/openapi/module/Module;", "testScope", "", "dependOnTest", "kotlin.gradle.gradle-java"})
public final class UtilsKt {
    @NotNull
    public static final DependencyScope getScopeContainingBoth(@NotNull DependencyScope scope1, @Nullable DependencyScope scope2) {
        DependencyScope result2;
        Intrinsics.checkNotNullParameter((Object)scope1, (String)"scope1");
        if (scope2 == null) {
            return scope1;
        }
        boolean compile = scope1.isForProductionCompile() || scope2.isForProductionCompile();
        boolean runtime = scope1.isForProductionRuntime() || scope2.isForProductionRuntime();
        boolean testCompile = scope1.isForTestCompile() || scope2.isForTestCompile();
        boolean testRuntime = scope1.isForTestRuntime() || scope2.isForTestRuntime();
        DependencyScope dependencyScope = result2 = compile || runtime ? DependencyScope.COMPILE : DependencyScope.TEST;
        if (result2.isForProductionCompile() != compile || result2.isForProductionRuntime() != runtime || result2.isForTestCompile() != testCompile || result2.isForTestRuntime() != testRuntime) {
            Logger.getInstance(KotlinJavaMPPSourceSetDataService.class).warn("Could not express cross-module dependency with flags Compile=" + compile + " Runtime=" + runtime + " TestCompile=" + testCompile + " TestRuntime=" + testRuntime);
        }
        return result2;
    }

    public static final void addModuleDependencyIfNeeded(@NotNull ModifiableRootModel rootModel, @NotNull Module dependeeModule, boolean testScope, boolean dependOnTest) {
        ModuleOrderEntry moduleOrderEntry;
        ModuleOrderEntry existingEntry;
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)dependeeModule, (String)"dependeeModule");
        ModuleOrderEntry moduleOrderEntry2 = existingEntry = rootModel.findModuleOrderEntry(dependeeModule);
        boolean existingDependOnTest = moduleOrderEntry2 != null ? moduleOrderEntry2.isProductionOnTestDependency() : false;
        ModuleOrderEntry moduleOrderEntry3 = existingEntry;
        DependencyScope requiredScope = UtilsKt.getScopeContainingBoth(testScope ? DependencyScope.TEST : DependencyScope.COMPILE, (DependencyScope)(moduleOrderEntry3 != null ? moduleOrderEntry3.getScope() : null));
        if (existingEntry != null) {
            DependencyScope dependencyScope = existingEntry.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"getScope(...)");
            DependencyScope existingScope = dependencyScope;
            if (requiredScope != existingScope || dependOnTest && !existingDependOnTest) {
                rootModel.removeOrderEntry((OrderEntry)existingEntry);
            } else {
                return;
            }
        }
        ModuleOrderEntry it = moduleOrderEntry = rootModel.addModuleOrderEntry(dependeeModule);
        boolean bl = false;
        it.setScope(requiredScope);
        it.setProductionOnTestDependency(dependOnTest || existingDependOnTest);
    }
}

