/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.ChangeListTodosPanel;
import com.intellij.ide.todo.ChangeListTodosTreeBuilder;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoView;
import com.intellij.ide.todo.TodoViewChangesSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/todo/TodoViewChangesSupportImpl;", "Lcom/intellij/ide/todo/TodoViewChangesSupport;", "<init>", "()V", "isContentVisible", "", "project", "Lcom/intellij/openapi/project/Project;", "getTabName", "", "createPanel", "Lcom/intellij/ide/todo/TodoPanel;", "todoView", "Lcom/intellij/ide/todo/TodoView;", "settings", "Lcom/intellij/ide/todo/TodoPanelSettings;", "content", "Lcom/intellij/ui/content/Content;", "factory", "Lcom/intellij/ide/todo/TodoTreeBuilderFactory;", "installListener", "Lcom/intellij/ide/todo/TodoViewChangesSupport$Listener;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "contentManagerFunc", "Lkotlin/Function0;", "Lcom/intellij/ui/content/ContentManager;", "contentFunc", "MyVcsListener", "intellij.platform.vcs.impl.lang"})
public final class TodoViewChangesSupportImpl
extends TodoViewChangesSupport {
    public boolean isContentVisible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectLevelVcsManager.Companion.getInstance(project).hasActiveVcss();
    }

    @NotNull
    public String getTabName(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = ChangeListTodosPanel.getTabName(project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTabName(...)");
        return string;
    }

    @NotNull
    public TodoPanel createPanel(@NotNull TodoView todoView, @NotNull TodoPanelSettings settings, @NotNull Content content, @NotNull TodoTreeBuilderFactory factory) {
        Intrinsics.checkNotNullParameter((Object)todoView, (String)"todoView");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        return new ChangeListTodosPanel(todoView, settings, content, factory){
            final /* synthetic */ TodoTreeBuilderFactory $factory;
            {
                this.$factory = $factory;
                super($todoView, $settings, $content);
            }

            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                TodoTreeBuilder builder = this.$factory.createTreeBuilder(tree, project);
                builder.init();
                Intrinsics.checkNotNull((Object)builder);
                return builder;
            }
        };
    }

    @NotNull
    public TodoPanel createPanel(@NotNull TodoView todoView, @NotNull TodoPanelSettings settings, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)todoView, (String)"todoView");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.createPanel(todoView, settings, content, TodoViewChangesSupportImpl::createPanel$lambda$0);
    }

    @NotNull
    public TodoViewChangesSupport.Listener installListener(@NotNull Project project, @NotNull MessageBusConnection connection, @NotNull Function0<? extends ContentManager> contentManagerFunc, @NotNull Function0<? extends Content> contentFunc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(contentManagerFunc, (String)"contentManagerFunc");
        Intrinsics.checkNotNullParameter(contentFunc, (String)"contentFunc");
        MyVcsListener listener = new MyVcsListener(project, contentManagerFunc, contentFunc);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)listener);
        return listener;
    }

    private static final TodoTreeBuilder createPanel$lambda$0(JTree tree, Project p) {
        return new ChangeListTodosTreeBuilder(tree, p);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/todo/TodoViewChangesSupportImpl$MyVcsListener;", "Lcom/intellij/openapi/vcs/VcsMappingListener;", "Lcom/intellij/ide/todo/TodoViewChangesSupport$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "contentManagerFunc", "Lkotlin/Function0;", "Lcom/intellij/ui/content/ContentManager;", "contentFunc", "Lcom/intellij/ui/content/Content;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "myIsVisible", "", "setVisible", "", "value", "directoryMappingChanged", "intellij.platform.vcs.impl.lang"})
    private static final class MyVcsListener
    implements VcsMappingListener,
    TodoViewChangesSupport.Listener {
        @NotNull
        private final Project project;
        @NotNull
        private final Function0<ContentManager> contentManagerFunc;
        @NotNull
        private final Function0<Content> contentFunc;
        private boolean myIsVisible;

        public MyVcsListener(@NotNull Project project, @NotNull Function0<? extends ContentManager> contentManagerFunc, @NotNull Function0<? extends Content> contentFunc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(contentManagerFunc, (String)"contentManagerFunc");
            Intrinsics.checkNotNullParameter(contentFunc, (String)"contentFunc");
            this.project = project;
            this.contentManagerFunc = contentManagerFunc;
            this.contentFunc = contentFunc;
        }

        public void setVisible(boolean value) {
            this.myIsVisible = value;
        }

        public void directoryMappingChanged() {
            ApplicationManager.getApplication().invokeLater(() -> MyVcsListener.directoryMappingChanged$lambda$0(this), ModalityState.nonModal());
        }

        private static final void directoryMappingChanged$lambda$0(MyVcsListener this$0) {
            ContentManager contentManager = (ContentManager)this$0.contentManagerFunc.invoke();
            if (contentManager == null || this$0.project.isDisposed()) {
                return;
            }
            Content content = (Content)this$0.contentFunc.invoke();
            boolean hasActiveVcss = ProjectLevelVcsManager.Companion.getInstance(this$0.project).hasActiveVcss();
            if (this$0.myIsVisible && !hasActiveVcss) {
                contentManager.removeContent(content, false);
                this$0.myIsVisible = false;
            } else if (!this$0.myIsVisible && hasActiveVcss) {
                contentManager.addContent(content);
                this$0.myIsVisible = true;
            }
        }
    }
}

