/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public final class MapEntryOrKeyValueHintProcessor
extends SignatureHintProcessor {
    @NlsSafe
    private static final String INDEX = "index";
    @NlsSafe
    private static final String ARG_NUM = "argNum";

    @Override
    public String getHintName() {
        return "groovy.transform.stc.MapEntryOrKeyValue";
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, String @NotNull [] options) {
        PsiType[] psiTypeArray;
        PsiType[] psiTypeArray2;
        if (method == null) {
            MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(1);
        }
        if (options == null) {
            MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(2);
        }
        int argNum = MapEntryOrKeyValueHintProcessor.extractArgNum(options);
        boolean index = MapEntryOrKeyValueHintProcessor.extractIndex(options);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (argNum >= parameters.length) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiParameter parameter = parameters[argNum];
        PsiType type = parameter.getType();
        PsiType substituted = substitutor.substitute(type);
        if (!InheritanceUtil.isInheritor((PsiType)substituted, (String)"java.util.Map")) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)1, (boolean)true);
        PsiClass mapEntry = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Map.Entry", method.getResolveScope());
        if (mapEntry == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiClassType mapEntryType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(mapEntry, new PsiType[]{key, value});
        if (index) {
            PsiType[] psiTypeArray3 = new PsiType[3];
            psiTypeArray3[0] = key;
            psiTypeArray3[1] = value;
            psiTypeArray2 = psiTypeArray3;
            psiTypeArray3[2] = PsiTypes.intType();
        } else {
            PsiType[] psiTypeArray4 = new PsiType[2];
            psiTypeArray4[0] = key;
            psiTypeArray2 = psiTypeArray4;
            psiTypeArray4[1] = value;
        }
        PsiType[] keyValueSignature = psiTypeArray2;
        if (index) {
            PsiType[] psiTypeArray5 = new PsiType[2];
            psiTypeArray5[0] = mapEntryType;
            psiTypeArray = psiTypeArray5;
            psiTypeArray5[1] = PsiTypes.intType();
        } else {
            PsiType[] psiTypeArray6 = new PsiType[1];
            psiTypeArray = psiTypeArray6;
            psiTypeArray6[0] = mapEntryType;
        }
        PsiType[] mapEntrySignature = psiTypeArray;
        List<PsiType[]> list = List.of(keyValueSignature, mapEntrySignature);
        if (list == null) {
            MapEntryOrKeyValueHintProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static int extractArgNum(String[] options) {
        for (String value : options) {
            Integer parsedValue = MapEntryOrKeyValueHintProcessor.parseArgNum(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options.length == 1) {
            return StringUtil.parseInt((String)options[0], (int)0);
        }
        return 0;
    }

    private static boolean extractIndex(String[] options) {
        for (String value : options) {
            Boolean parsedValue = MapEntryOrKeyValueHintProcessor.parseIndex(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options.length == 1) {
            return Boolean.parseBoolean(options[0]);
        }
        return false;
    }

    private static Boolean parseIndex(String value) {
        Couple<String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        if (INDEX.equals(pair.getFirst())) {
            return Boolean.valueOf((String)pair.getSecond());
        }
        return null;
    }

    private static Integer parseArgNum(String value) {
        Couple<String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        if (ARG_NUM.equals(pair.getFirst())) {
            return StringUtil.parseInt((String)((String)pair.getSecond()), (int)0);
        }
        return null;
    }

    @Nullable
    private static Couple<String> parseValue(String value) {
        String[] split = value.split("=");
        return split.length == 2 ? Couple.of((Object)split[0].trim(), (Object)split[1].trim()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inferExpectedSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferExpectedSignatures";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

