/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.widget;

import com.intellij.codeWithMe.ClientId;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.ide.msg.GrazieInitializerManager;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.ide.ui.widget.GrazieStatusBarWidget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/ide/ui/widget/GrazieStatusBarWidgetFactory;", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "<init>", "()V", "getId", "", "getDisplayName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "createWidget", "Lcom/intellij/openapi/wm/StatusBarWidget;", "disposeWidget", "", "widget", "canBeEnabledOn", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "update", "prevState", "Lcom/intellij/grazie/GrazieConfig$State;", "newState", "Companion", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieStatusBarWidgetFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieStatusBarWidgetFactory.kt\ncom/intellij/grazie/ide/ui/widget/GrazieStatusBarWidgetFactory\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,71:1\n42#2,3:72\n13805#3:75\n13806#3:78\n30#4,2:76\n*S KotlinDebug\n*F\n+ 1 GrazieStatusBarWidgetFactory.kt\ncom/intellij/grazie/ide/ui/widget/GrazieStatusBarWidgetFactory\n*L\n27#1:72,3\n60#1:75\n60#1:78\n61#1:76,2\n*E\n"})
public final class GrazieStatusBarWidgetFactory
implements StatusBarWidgetFactory,
GrazieStateLifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String widgetId = "GrazieStatusBarWidget";

    public GrazieStatusBarWidgetFactory() {
        boolean $i$f$service = false;
        Class<GrazieInitializerManager> serviceClass$iv = GrazieInitializerManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((GrazieInitializerManager)object).register(this);
    }

    @NotNull
    public String getId() {
        return widgetId;
    }

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.status.bar.widget.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Registry.Companion.is("grazie.enable.status.bar.widget", false) && !GrazieCloudConnector.Companion.hasAdditionalConnectors() && GrazieConfig.Companion.get().getExplicitlyChosenProcessing() == GrazieConfig.State.Processing.Cloud;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (StatusBarWidget)new GrazieStatusBarWidget(project);
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Disposer.dispose((Disposable)((Disposable)widget));
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        return true;
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (newState.getExplicitlyChosenProcessing() == prevState.getExplicitlyChosenProcessing()) {
            return;
        }
        ApplicationKt.getApplication().invokeLater(() -> GrazieStatusBarWidgetFactory.update$lambda$0(this), ModalityState.any());
    }

    private static final void update$lambda$0(GrazieStatusBarWidgetFactory this$0) {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)project);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            StatusBarWidgetsManager statusBarWidgetsManager = (StatusBarWidgetsManager)object;
            StatusBarWidgetFactory statusBarWidgetFactory = this$0;
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            statusBarWidgetsManager.updateWidget(statusBarWidgetFactory, coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/grazie/ide/ui/widget/GrazieStatusBarWidgetFactory$Companion;", "", "<init>", "()V", "widgetId", "", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

