/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ClassScanResult {
    final Set<Path> changedClasses = new HashSet<Path>();
    final Set<Path> deletedClasses = new HashSet<Path>();
    final Set<Path> addedClasses = new HashSet<Path>();
    final Set<String> changedClassNames = new HashSet<String>();
    final Set<String> deletedClassNames = new HashSet<String>();
    final Set<String> addedClassNames = new HashSet<String>();
    boolean compilationHappened;

    public boolean isChanged() {
        return !this.changedClasses.isEmpty() || !this.deletedClasses.isEmpty() || !this.addedClasses.isEmpty() || this.compilationHappened;
    }

    public static ClassScanResult merge(ClassScanResult m1, ClassScanResult m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        ClassScanResult ret = new ClassScanResult();
        ret.changedClasses.addAll(m1.changedClasses);
        ret.deletedClasses.addAll(m1.deletedClasses);
        ret.addedClasses.addAll(m1.addedClasses);
        ret.changedClassNames.addAll(m1.changedClassNames);
        ret.deletedClassNames.addAll(m1.deletedClassNames);
        ret.addedClassNames.addAll(m1.addedClassNames);
        ret.changedClasses.addAll(m2.changedClasses);
        ret.deletedClasses.addAll(m2.deletedClasses);
        ret.addedClasses.addAll(m2.addedClasses);
        ret.changedClassNames.addAll(m2.changedClassNames);
        ret.deletedClassNames.addAll(m2.deletedClassNames);
        ret.addedClassNames.addAll(m2.addedClassNames);
        ret.compilationHappened = m1.compilationHappened | m2.compilationHappened;
        return ret;
    }

    public void addDeletedClass(Path moduleClassesPath, Path classFilePath) {
        this.deletedClasses.add(classFilePath);
        this.deletedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    public void addChangedClass(Path moduleClassesPath, Path classFilePath) {
        this.changedClasses.add(classFilePath);
        this.changedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    public void addAddedClass(Path moduleClassesPath, Path classFilePath) {
        this.addedClasses.add(classFilePath);
        this.addedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    public Set<String> getChangedClassNames() {
        return this.changedClassNames;
    }

    public Set<Path> getChangedClasses() {
        return this.changedClasses;
    }

    public Set<Path> getDeletedClasses() {
        return this.deletedClasses;
    }

    public Set<Path> getAddedClasses() {
        return this.addedClasses;
    }

    public Set<String> getDeletedClassNames() {
        return this.deletedClassNames;
    }

    public Set<String> getAddedClassNames() {
        return this.addedClassNames;
    }

    public boolean isCompilationHappened() {
        return this.compilationHappened;
    }

    private String toName(Path moduleClassesPath, Path classFilePath) {
        String cf = moduleClassesPath.relativize(classFilePath).toString().replace(moduleClassesPath.getFileSystem().getSeparator(), ".");
        return cf.substring(0, cf.length() - ".class".length());
    }
}

