/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingEntityRenderer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    private static final float EYE_BED_OFFSET = 0.1f;
    protected M model;
    protected final ItemModelResolver itemModelResolver;
    protected final List<RenderLayer<S, M>> layers = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.itemModelResolver = p_174289_.getItemModelResolver();
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    public final boolean addLayer(RenderLayer<S, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    public M getModel() {
        return this.model;
    }

    @Override
    protected AABB getBoundingBoxForCulling(T p_361472_) {
        AABB aabb = super.getBoundingBoxForCulling(p_361472_);
        if (((LivingEntity)p_361472_).getItemBySlot(EquipmentSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float f = 0.5f;
            return aabb.inflate(0.5, 0.5, 0.5);
        }
        return aabb;
    }

    @Override
    public void render(S p_364280_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction direction;
        if (ForgeEventFactoryClient.onRenderLivingPre(p_364280_, (LivingEntityRenderer)this, (PoseStack)p_115311_, (MultiBufferSource)p_115312_, (int)p_115313_)) {
            return;
        }
        p_115311_.pushPose();
        if (p_364280_.hasPose(Pose.SLEEPING) && (direction = ((LivingEntityRenderState)p_364280_).bedOrientation) != null) {
            float f = ((LivingEntityRenderState)p_364280_).eyeHeight - 0.1f;
            p_115311_.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
        }
        float f1 = ((LivingEntityRenderState)p_364280_).scale;
        p_115311_.scale(f1, f1, f1);
        this.setupRotations(p_364280_, p_115311_, ((LivingEntityRenderState)p_364280_).bodyRot, f1);
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_364280_, p_115311_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        this.model.setupAnim(p_364280_);
        boolean flag1 = this.isBodyVisible(p_364280_);
        boolean flag = !flag1 && !((LivingEntityRenderState)p_364280_).isInvisibleToPlayer;
        RenderType rendertype = this.getRenderType(p_364280_, flag1, flag, ((LivingEntityRenderState)p_364280_).appearsGlowing);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.getBuffer(rendertype);
            int i = LivingEntityRenderer.getOverlayCoords(p_364280_, this.getWhiteOverlayProgress(p_364280_));
            int j = flag ? 0x26FFFFFF : -1;
            int k = ARGB.multiply(j, this.getModelTint(p_364280_));
            this.model.renderToBuffer(p_115311_, vertexconsumer, p_115313_, i, k);
        }
        if (this.shouldRenderLayers(p_364280_)) {
            for (RenderLayer<S, M> renderlayer : this.layers) {
                renderlayer.render(p_115311_, p_115312_, p_115313_, p_364280_, ((LivingEntityRenderState)p_364280_).yRot, ((LivingEntityRenderState)p_364280_).xRot);
            }
        }
        p_115311_.popPose();
        super.render(p_364280_, p_115311_, p_115312_, p_115313_);
        ForgeEventFactoryClient.onRenderLivingPost(p_364280_, (LivingEntityRenderer)this, (PoseStack)p_115311_, (MultiBufferSource)p_115312_, (int)p_115313_);
    }

    protected boolean shouldRenderLayers(S p_360804_) {
        return true;
    }

    protected int getModelTint(S p_361319_) {
        return -1;
    }

    public abstract ResourceLocation getTextureLocation(S var1);

    @Nullable
    protected RenderType getRenderType(S p_369777_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_369777_);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull(resourcelocation);
        }
        if (p_115323_) {
            return this.model.renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline(resourcelocation) : null;
    }

    public static int getOverlayCoords(LivingEntityRenderState p_365259_, float p_115340_) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)p_115340_), (int)OverlayTexture.v((boolean)p_365259_.hasRedOverlay));
    }

    protected boolean isBodyVisible(S p_363166_) {
        return !((LivingEntityRenderState)p_363166_).isInvisible;
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(S p_361206_) {
        return ((LivingEntityRenderState)p_361206_).isFullyFrozen;
    }

    protected void setupRotations(S p_370120_, PoseStack p_115318_, float p_115319_, float p_115320_) {
        if (this.isShaking(p_370120_)) {
            p_115319_ += (float)(Math.cos((float)Mth.floor(((LivingEntityRenderState)p_370120_).ageInTicks) * 3.25f) * Math.PI * (double)0.4f);
        }
        if (!p_370120_.hasPose(Pose.SLEEPING)) {
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - p_115319_));
        }
        if (((LivingEntityRenderState)p_370120_).deathTime > 0.0f) {
            float f = (((LivingEntityRenderState)p_370120_).deathTime - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt(f)) > 1.0f) {
                f = 1.0f;
            }
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * this.getFlipDegrees()));
        } else if (((LivingEntityRenderState)p_370120_).isAutoSpinAttack) {
            p_115318_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - ((LivingEntityRenderState)p_370120_).xRot));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(((LivingEntityRenderState)p_370120_).ageInTicks * -75.0f));
        } else if (p_370120_.hasPose(Pose.SLEEPING)) {
            Direction direction = ((LivingEntityRenderState)p_370120_).bedOrientation;
            float f1 = direction != null ? LivingEntityRenderer.sleepDirectionToRotation(direction) : p_115319_;
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1));
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(this.getFlipDegrees()));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
        } else if (((LivingEntityRenderState)p_370120_).isUpsideDown) {
            p_115318_.translate(0.0f, (((LivingEntityRenderState)p_370120_).boundingBoxHeight + 0.1f) / p_115320_, 0.0f);
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getFlipDegrees() {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(S p_367139_) {
        return 0.0f;
    }

    protected void scale(S p_363445_, PoseStack p_115315_) {
    }

    @Override
    protected boolean shouldShowName(T p_115333_, double p_365822_) {
        boolean flag;
        if (((Entity)p_115333_).isDiscrete()) {
            float f = 32.0f;
            if (p_365822_ >= 1024.0) {
                return false;
            }
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        boolean bl = flag = !((Entity)p_115333_).isInvisibleTo(localplayer);
        if (p_115333_ != localplayer) {
            PlayerTeam team = ((Entity)p_115333_).getTeam();
            PlayerTeam team1 = localplayer.getTeam();
            if (team != null) {
                Team.Visibility team$visibility = ((Team)team).getNameTagVisibility();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.isAlliedTo(team1) && (((Team)team).canSeeFriendlyInvisibles() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.isAlliedTo(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && p_115333_ != minecraft.getCameraEntity() && flag && !((Entity)p_115333_).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String s;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting(p_194454_.getName().getString())) || "Grumm".equals(s))) {
            Player player;
            return !(p_194454_ instanceof Player && !(player = (Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE));
        }
        return false;
    }

    @Override
    protected float getShadowRadius(S p_363803_) {
        return super.getShadowRadius(p_363803_) * ((LivingEntityRenderState)p_363803_).scale;
    }

    @Override
    public void extractRenderState(T p_368665_, S p_363057_, float p_364497_) {
        BlockItem blockitem;
        super.extractRenderState(p_368665_, p_363057_, p_364497_);
        float f = Mth.rotLerp(p_364497_, ((LivingEntity)p_368665_).yHeadRotO, ((LivingEntity)p_368665_).yHeadRot);
        ((LivingEntityRenderState)p_363057_).bodyRot = LivingEntityRenderer.solveBodyRot(p_368665_, f, p_364497_);
        ((LivingEntityRenderState)p_363057_).yRot = Mth.wrapDegrees(f - ((LivingEntityRenderState)p_363057_).bodyRot);
        ((LivingEntityRenderState)p_363057_).xRot = ((Entity)p_368665_).getXRot(p_364497_);
        ((LivingEntityRenderState)p_363057_).customName = ((Entity)p_368665_).getCustomName();
        ((LivingEntityRenderState)p_363057_).isUpsideDown = LivingEntityRenderer.isEntityUpsideDown(p_368665_);
        if (((LivingEntityRenderState)p_363057_).isUpsideDown) {
            ((LivingEntityRenderState)p_363057_).xRot *= -1.0f;
            ((LivingEntityRenderState)p_363057_).yRot *= -1.0f;
        }
        if (!((Entity)p_368665_).isPassenger() && ((LivingEntity)p_368665_).isAlive()) {
            ((LivingEntityRenderState)p_363057_).walkAnimationPos = ((LivingEntity)p_368665_).walkAnimation.position(p_364497_);
            ((LivingEntityRenderState)p_363057_).walkAnimationSpeed = ((LivingEntity)p_368665_).walkAnimation.speed(p_364497_);
        } else {
            ((LivingEntityRenderState)p_363057_).walkAnimationPos = 0.0f;
            ((LivingEntityRenderState)p_363057_).walkAnimationSpeed = 0.0f;
        }
        Entity entity = ((Entity)p_368665_).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            ((LivingEntityRenderState)p_363057_).wornHeadAnimationPos = livingentity.walkAnimation.position(p_364497_);
        } else {
            ((LivingEntityRenderState)p_363057_).wornHeadAnimationPos = ((LivingEntityRenderState)p_363057_).walkAnimationPos;
        }
        ((LivingEntityRenderState)p_363057_).scale = ((LivingEntity)p_368665_).getScale();
        ((LivingEntityRenderState)p_363057_).ageScale = ((LivingEntity)p_368665_).getAgeScale();
        ((LivingEntityRenderState)p_363057_).pose = ((Entity)p_368665_).getPose();
        ((LivingEntityRenderState)p_363057_).bedOrientation = ((LivingEntity)p_368665_).getBedOrientation();
        if (((LivingEntityRenderState)p_363057_).bedOrientation != null) {
            ((LivingEntityRenderState)p_363057_).eyeHeight = ((Entity)p_368665_).getEyeHeight(Pose.STANDING);
        }
        ((LivingEntityRenderState)p_363057_).isFullyFrozen = ((Entity)p_368665_).isFullyFrozen();
        ((LivingEntityRenderState)p_363057_).isBaby = ((LivingEntity)p_368665_).isBaby();
        ((LivingEntityRenderState)p_363057_).isInWater = ((Entity)p_368665_).isInWater();
        ((LivingEntityRenderState)p_363057_).isInWater = ((Entity)p_368665_).isInWaterOrSwimmable();
        ((LivingEntityRenderState)p_363057_).isAutoSpinAttack = ((LivingEntity)p_368665_).isAutoSpinAttack();
        ((LivingEntityRenderState)p_363057_).hasRedOverlay = ((LivingEntity)p_368665_).hurtTime > 0 || ((LivingEntity)p_368665_).deathTime > 0;
        ItemStack itemstack = ((LivingEntity)p_368665_).getItemBySlot(EquipmentSlot.HEAD);
        FeatureElement featureElement = itemstack.getItem();
        if (featureElement instanceof BlockItem && (featureElement = (blockitem = (BlockItem)featureElement).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock abstractskullblock = (AbstractSkullBlock)featureElement;
            ((LivingEntityRenderState)p_363057_).wornHeadType = abstractskullblock.getType();
            ((LivingEntityRenderState)p_363057_).wornHeadProfile = (ResolvableProfile)itemstack.get(DataComponents.PROFILE);
            ((LivingEntityRenderState)p_363057_).headItem.clear();
        } else {
            ((LivingEntityRenderState)p_363057_).wornHeadType = null;
            ((LivingEntityRenderState)p_363057_).wornHeadProfile = null;
            if (!HumanoidArmorLayer.shouldRender(itemstack, EquipmentSlot.HEAD)) {
                this.itemModelResolver.updateForLiving(((LivingEntityRenderState)p_363057_).headItem, itemstack, ItemDisplayContext.HEAD, p_368665_);
            } else {
                ((LivingEntityRenderState)p_363057_).headItem.clear();
            }
        }
        ((LivingEntityRenderState)p_363057_).deathTime = ((LivingEntity)p_368665_).deathTime > 0 ? (float)((LivingEntity)p_368665_).deathTime + p_364497_ : 0.0f;
        Minecraft minecraft = Minecraft.getInstance();
        ((LivingEntityRenderState)p_363057_).isInvisibleToPlayer = ((LivingEntityRenderState)p_363057_).isInvisible && ((Entity)p_368665_).isInvisibleTo(minecraft.player);
        ((LivingEntityRenderState)p_363057_).appearsGlowing = minecraft.shouldEntityAppearGlowing((Entity)p_368665_);
    }

    @Override
    protected void extractAdditionalHitboxes(T p_392957_, ImmutableList.Builder<HitboxRenderState> p_396936_, float p_397822_) {
        super.extractAdditionalHitboxes(p_392957_, p_396936_, p_397822_);
        AABB aabb = ((Entity)p_392957_).getBoundingBox();
        float f = 0.01f;
        HitboxRenderState hitboxrenderstate = new HitboxRenderState(aabb.minX - ((Entity)p_392957_).getX(), (double)(((Entity)p_392957_).getEyeHeight() - 0.01f), aabb.minZ - ((Entity)p_392957_).getZ(), aabb.maxX - ((Entity)p_392957_).getX(), (double)(((Entity)p_392957_).getEyeHeight() + 0.01f), aabb.maxZ - ((Entity)p_392957_).getZ(), 1.0f, 0.0f, 0.0f);
        p_396936_.add((Object)hitboxrenderstate);
    }

    private static float solveBodyRot(LivingEntity p_367822_, float p_362662_, float p_362007_) {
        Entity entity = p_367822_.getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            float f2 = Mth.rotLerp(p_362007_, livingentity.yBodyRotO, livingentity.yBodyRot);
            float f = 85.0f;
            float f1 = Mth.clamp(Mth.wrapDegrees(p_362662_ - f2), -85.0f, 85.0f);
            f2 = p_362662_ - f1;
            if (Math.abs(f1) > 50.0f) {
                f2 += f1 * 0.2f;
            }
            return f2;
        }
        return Mth.rotLerp(p_362007_, p_367822_.yBodyRotO, p_367822_.yBodyRot);
    }
}

