/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;

public class StartAttacking {
    public static <E extends Mob> BehaviorControl<E> create(TargetFinder<E> p_368894_) {
        return StartAttacking.create((p_362883_, p_24212_) -> true, p_368894_);
    }

    public static <E extends Mob> BehaviorControl<E> create(StartAttackingCondition<E> p_363679_, TargetFinder<E> p_360766_) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> p_258782_) -> p_258782_.group(p_258782_.absent(MemoryModuleType.ATTACK_TARGET), p_258782_.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)p_258782_, (p_258778_, p_258779_) -> (p_359048_, p_359049_, p_359050_) -> {
            if (!p_363679_.test(p_359048_, p_359049_)) {
                return false;
            }
            Optional<LivingEntity> optional = p_360766_.get(p_359048_, p_359049_);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingentity = optional.get();
            if (!p_359049_.canAttack(livingentity)) {
                return false;
            }
            LivingChangeTargetEvent changeTargetEvent = ForgeEventFactory.onLivingChangeTargetBehavior((LivingEntity)p_359049_, (LivingEntity)livingentity);
            if (changeTargetEvent == null) {
                return false;
            }
            p_258778_.set(changeTargetEvent.getNewTarget());
            p_258779_.erase();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface StartAttackingCondition<E> {
        public boolean test(ServerLevel var1, E var2);
    }

    @FunctionalInterface
    public static interface TargetFinder<E> {
        public Optional<? extends LivingEntity> get(ServerLevel var1, E var2);
    }
}

