/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root.colibri.mucclient;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.annotations.EnabledByConfig;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/colibri/muc-client")
@EnabledByConfig(value=RestApis.COLIBRI)
public class MucClient {
    @Inject
    protected XmppConnection xmppConnection;

    @Path(value="/add")
    @POST
    @Consumes(value={"application/json"})
    public Response addMucClient(String requestBody) throws ParseException {
        Object o = new JSONParser().parse(requestBody);
        if (!(o instanceof JSONObject)) {
            return Response.status((int)400).build();
        }
        if (this.xmppConnection.addMucClient((JSONObject)o)) {
            return Response.ok().build();
        }
        return Response.status((int)400).build();
    }

    @Path(value="/remove")
    @POST
    @Consumes(value={"application/json"})
    public Response removeMucClient(String requestBody) throws ParseException {
        Object o = new JSONParser().parse(requestBody);
        if (!(o instanceof JSONObject)) {
            return Response.status((int)400).build();
        }
        if (this.xmppConnection.removeMucClient((JSONObject)o)) {
            return Response.ok().build();
        }
        return Response.status((int)400).build();
    }

    @Path(value="/list")
    @GET
    @Produces(value={"application/json"})
    public String listMucClientIDs() {
        return this.xmppConnection.getMucClientIds();
    }
}

