/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import jakarta.servlet.Servlet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.websocket.ColibriWebSocketServlet;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService;", "", "webserverIsTls", "", "<init>", "(Z)V", "baseUrls", "", "", "relayBaseUrls", "getColibriWebSocketUrls", "conferenceId", "endpointId", "pwd", "getColibriRelayWebSocketUrls", "relayId", "registerServlet", "", "servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nColibriWebSocketService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColibriWebSocketService.kt\norg/jitsi/videobridge/websocket/ColibriWebSocketService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1563#2:125\n1634#2,3:126\n1563#2:129\n1634#2,3:130\n1563#2:133\n1634#2,3:134\n1563#2:137\n1634#2,3:138\n*S KotlinDebug\n*F\n+ 1 ColibriWebSocketService.kt\norg/jitsi/videobridge/websocket/ColibriWebSocketService\n*L\n40#1:125\n40#1:126,3\n44#1:129\n44#1:130,3\n69#1:133\n69#1:134,3\n79#1:137\n79#1:138,3\n*E\n"})
public final class ColibriWebSocketService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> baseUrls;
    @NotNull
    private final List<String> relayBaseUrls;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default((Object)Companion, null, null, (int)3, null);
    @NotNull
    private static final String COLIBRI_WS_ENDPOINT = "colibri-ws";
    @NotNull
    private static final String COLIBRI_RELAY_WS_ENDPOINT = "colibri-relay-ws";
    @NotNull
    public static final String COLIBRI_WS_PATH = "/colibri-ws/";
    @NotNull
    public static final String COLIBRI_RELAY_WS_PATH = "/colibri-relay-ws/";

    public ColibriWebSocketService(boolean webserverIsTls) {
        if (WebsocketServiceConfig.config.getEnabled()) {
            List list;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Boolean bl = WebsocketServiceConfig.config.getUseTls();
            boolean useTls2 = bl != null ? bl : webserverIsTls;
            String protocol = useTls2 ? "wss" : "ws";
            Iterable iterable = WebsocketServiceConfig.config.getDomains();
            ColibriWebSocketService colibriWebSocketService = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(protocol + "://" + it + COLIBRI_WS_PATH + WebsocketServiceConfig.config.getServerId());
            }
            colibriWebSocketService.baseUrls = (List)destination$iv$iv;
            ColibriWebSocketService colibriWebSocketService2 = this;
            if (RelayConfig.config.getEnabled()) {
                $this$map$iv = WebsocketServiceConfig.config.getRelayDomains();
                colibriWebSocketService = colibriWebSocketService2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(protocol + "://" + it + COLIBRI_RELAY_WS_PATH + WebsocketServiceConfig.config.getServerId());
                }
                list = (List)destination$iv$iv;
                colibriWebSocketService2 = colibriWebSocketService;
            } else {
                list = colibriWebSocketService2.relayBaseUrls = CollectionsKt.emptyList();
            }
            if (this.baseUrls.isEmpty() || this.relayBaseUrls.isEmpty()) {
                logger.warn((Object)("Websockets enabled, but no domains specified: URLs=" + this.baseUrls + ", Relay URLs=" + this.relayBaseUrls));
            } else {
                logger.info((Object)("Base URL: " + this.baseUrls + " Relay URL: " + this.relayBaseUrls));
            }
        } else {
            logger.info((Object)"WebSockets are not enabled");
            this.baseUrls = CollectionsKt.emptyList();
            this.relayBaseUrls = CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getColibriWebSocketUrls(@NotNull String conferenceId, @NotNull String endpointId, @NotNull String pwd) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)conferenceId, (String)"conferenceId");
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        Iterable $this$map$iv = this.baseUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "/" + conferenceId + "/" + endpointId + "?pwd=" + pwd);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getColibriRelayWebSocketUrls(@NotNull String conferenceId, @NotNull String relayId, @NotNull String pwd) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)conferenceId, (String)"conferenceId");
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        Iterable $this$map$iv = this.relayBaseUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "/" + conferenceId + "/" + relayId + "?pwd=" + pwd);
        }
        return (List)destination$iv$iv;
    }

    public final void registerServlet(@NotNull ServletContextHandler servletContextHandler, @NotNull Videobridge videobridge) {
        Intrinsics.checkNotNullParameter((Object)servletContextHandler, (String)"servletContextHandler");
        Intrinsics.checkNotNullParameter((Object)videobridge, (String)"videobridge");
        if (WebsocketServiceConfig.config.getEnabled()) {
            ServletHolder servletHolder;
            logger.info((Object)("Registering servlet with baseUrls = " + this.baseUrls + ", relayBaseUrls = " + this.relayBaseUrls));
            ServletHolder $this$registerServlet_u24lambda_u240 = servletHolder = new ServletHolder();
            boolean bl = false;
            $this$registerServlet_u24lambda_u240.setServlet((Servlet)new ColibriWebSocketServlet(WebsocketServiceConfig.config.getServerId(), videobridge));
            ServletHolder holder = servletHolder;
            servletContextHandler.addServlet(holder, "/colibri-ws/*");
            servletContextHandler.addServlet(holder, "/colibri-relay-ws/*");
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContextHandler, null);
        } else {
            logger.info((Object)"Disabled, not registering servlet");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService$Companion;", "", "<init>", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "COLIBRI_WS_ENDPOINT", "", "COLIBRI_RELAY_WS_ENDPOINT", "COLIBRI_WS_PATH", "COLIBRI_RELAY_WS_PATH", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

