/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.movies.MovieScraper;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class MovieScraperPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<MovieScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableScraper;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JComboBox<MovieConnectors> cbNfoFormat;
    private JTextPane tpScraperDescription;
    private JCheckBox chckbxScraperFallback;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JPanel panelScraperOptions;

    public MovieScraperPanel() {
        MediaScraper defaultMediaScraper = MovieModuleManager.getInstance().getMovieList().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : MovieModuleManager.getInstance().getMovieList().getAvailableMediaScrapers()) {
            MovieScraper movieScraper = new MovieScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                movieScraper.setDefaultScraper(true);
                selectedIndex = counter;
            }
            this.scrapers.add(movieScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(e -> this.checkChanges());
        this.cbMovieNfoFilename2.addItemListener(e -> this.checkChanges());
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            int row;
            MovieScraper changedScraper;
            if (arg0.getColumn() == 0 && (changedScraper = this.scrapers.get(row = arg0.getFirstRow())).getDefaultScraper().booleanValue()) {
                this.settings.setMovieScraper(changedScraper.getScraperId());
                for (MovieScraper scraper : this.scrapers) {
                    if (scraper == changedScraper) continue;
                    scraper.setDefaultScraper(Boolean.FALSE);
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][400lp,grow]"));
        JLabel lblMovieScraper = new JLabel(TmmResourceBundle.getString("wizard.movie.scraper"));
        this.add((Component)lblMovieScraper, "cell 0 0");
        TmmFontHelper.changeFont(lblMovieScraper, 1.3333, 1);
        JPanel panelMovieScrapers = new JPanel();
        this.add((Component)panelMovieScrapers, "cell 0 1,grow, wmin 0");
        panelMovieScrapers.setLayout((LayoutManager)new MigLayout("", "[][][600lp,grow]", "[150lp:200lp,grow][][][][][20lp][][]"));
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelMovieScrapers.add((Component)scrollPaneScraper, "cell 0 0 2 1,grow, wmin 0");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                MovieScraper scraper = MovieScraperPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        scrollPaneScraper.setViewportView(this.tableScraper);
        NoBorderScrollPane scrollPaneScraperDetails = new NoBorderScrollPane();
        panelMovieScrapers.add((Component)scrollPaneScraperDetails, "cell 2 0 1 8,grow");
        scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][]"));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,growx,wmin 0, aligny top");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,growx, wmin 0, aligny top");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelMovieScrapers.add((Component)lblScraperLanguage, "cell 0 2");
        this.cbScraperLanguage = new JComboBox();
        this.cbScraperLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.valuesSorted()));
        panelMovieScrapers.add(this.cbScraperLanguage, "cell 1 2");
        JLabel lblCountry = new JLabel(TmmResourceBundle.getString("Settings.certificationCountry"));
        panelMovieScrapers.add((Component)lblCountry, "cell 0 3");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        this.cbCertificationCountry.setModel(new DefaultComboBoxModel<CountryCode>(CountryCode.values()));
        panelMovieScrapers.add(this.cbCertificationCountry, "cell 1 3");
        this.chckbxScraperFallback = new JCheckBox(TmmResourceBundle.getString("Settings.scraperfallback"));
        panelMovieScrapers.add((Component)this.chckbxScraperFallback, "cell 0 4 2 1");
        JLabel lblNfoFormat = new JLabel("NFO format");
        panelMovieScrapers.add((Component)lblNfoFormat, "flowx,cell 0 6 2 1");
        JPanel panel = new JPanel();
        panelMovieScrapers.add((Component)panel, "cell 0 7 2 1,growx");
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][][][]", "[][]"));
        JLabel lblNfoFileNaming = new JLabel(TmmResourceBundle.getString("Settings.nofFileNaming"));
        panel.add((Component)lblNfoFileNaming, "cell 0 0");
        this.cbMovieNfoFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + ".nfo");
        panel.add((Component)this.cbMovieNfoFilename1, "cell 1 0");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panel.add((Component)this.cbMovieNfoFilename2, "cell 1 1");
        this.cbNfoFormat = new JComboBox<MovieConnectors>(MovieConnectors.values());
        panelMovieScrapers.add(this.cbNfoFormat, "cell 0 6 2 1");
    }

    private void checkChanges() {
        this.settings.clearNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"scraperFallback");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxScraperFallback, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty movieScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.default")).setColumnClass(Boolean.class);
        BeanProperty movieScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_1).setColumnClass(Icon.class).setEditable(false);
        BeanProperty movieScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"movieConnector");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding.bind();
    }
}

