/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

abstract class AbstractCheckComboBoxMovieUIFilter<E>
extends AbstractMovieUIFilter {
    protected TmmCheckComboBox<E> checkComboBox;

    AbstractCheckComboBoxMovieUIFilter() {
    }

    @Override
    protected JComponent createFilterComponent() {
        this.checkComboBox = new TmmCheckComboBox();
        this.checkComboBox.setSingleLineEditor();
        return this.checkComboBox;
    }

    @Override
    public String getFilterValueAsString() {
        try {
            ArrayList<String> values = new ArrayList<String>();
            for (E type : this.checkComboBox.getSelectedItems()) {
                values.add(this.parseTypeToString(type));
            }
            return objectMapper.writeValueAsString(values);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        ArrayList<E> selectedItems = new ArrayList<E>();
        try {
            List values = (List)objectMapper.readValue((String)value, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, String.class));
            for (String valueAsString : values) {
                selectedItems.add(this.parseStringToType(valueAsString));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkComboBox.setSelectedItems(selectedItems);
    }

    @Override
    public void clearFilter() {
        this.checkComboBox.clearSelection();
    }

    protected void setValues(List<E> values) {
        this.checkComboBox.removeActionListener(this.filterComponentActionListener);
        List<E> selectedItems = this.checkComboBox.getSelectedItems();
        this.checkComboBox.setItems(values);
        if (!selectedItems.isEmpty()) {
            this.checkComboBox.setSelectedItems(selectedItems);
        }
        this.checkComboBox.addActionListener(this.filterComponentActionListener);
    }

    protected void setValues(E ... values) {
        this.setValues(Arrays.asList(values));
    }

    protected abstract String parseTypeToString(E var1) throws Exception;

    protected abstract E parseStringToType(String var1) throws Exception;
}

