/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.internal.math.DoubleAdder;
import io.jenetics.stat.DoubleMoments;
import io.jenetics.stat.MomentStatistics;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;

public class DoubleMomentStatistics
extends MomentStatistics
implements DoubleConsumer {
    private double _min = Double.POSITIVE_INFINITY;
    private double _max = Double.NEGATIVE_INFINITY;
    private final DoubleAdder _sum = new DoubleAdder();

    @Override
    public void accept(double value) {
        super.accept(value);
        this._min = Math.min(this._min, value);
        this._max = Math.max(this._max, value);
        this._sum.add(value);
    }

    public DoubleMomentStatistics combine(DoubleMomentStatistics other) {
        super.combine(other);
        this._min = Math.min(this._min, other._min);
        this._max = Math.max(this._max, other._max);
        this._sum.add(other._sum);
        return this;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getSum() {
        return this._sum.doubleValue();
    }

    public boolean sameState(DoubleMomentStatistics other) {
        return this == other || Double.compare(this._min, other._min) == 0 && Double.compare(this._max, other._max) == 0 && this._sum.sameState(other._sum) && super.sameState(other);
    }

    public DoubleMoments toDoubleMoments() {
        return DoubleMoments.of(this);
    }

    public String toString() {
        return String.format("Summary[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s, s\u00b2=%s, S=%s, K=%s]", this.getCount(), this._min, this._max, this._sum.doubleValue(), this.getMean(), this.getVariance(), this.getSkewness(), this.getKurtosis());
    }

    public static <T> Collector<T, ?, DoubleMomentStatistics> toDoubleMomentStatistics(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(DoubleMomentStatistics::new, (r, t) -> r.accept(mapper.applyAsDouble(t)), DoubleMomentStatistics::combine, new Collector.Characteristics[0]);
    }
}

