﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cost-optimization-hub/CostOptimizationHub_EXPORTS.h>
#include <aws/cost-optimization-hub/model/RdsDbInstanceConfiguration.h>
#include <aws/cost-optimization-hub/model/ResourceCostCalculation.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CostOptimizationHub {
namespace Model {

/**
 * <p>Contains the details of an Amazon RDS DB instance.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/RdsDbInstance">AWS
 * API Reference</a></p>
 */
class RdsDbInstance {
 public:
  AWS_COSTOPTIMIZATIONHUB_API RdsDbInstance() = default;
  AWS_COSTOPTIMIZATIONHUB_API RdsDbInstance(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API RdsDbInstance& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon RDS DB instance configuration used for recommendations.</p>
   */
  inline const RdsDbInstanceConfiguration& GetConfiguration() const { return m_configuration; }
  inline bool ConfigurationHasBeenSet() const { return m_configurationHasBeenSet; }
  template <typename ConfigurationT = RdsDbInstanceConfiguration>
  void SetConfiguration(ConfigurationT&& value) {
    m_configurationHasBeenSet = true;
    m_configuration = std::forward<ConfigurationT>(value);
  }
  template <typename ConfigurationT = RdsDbInstanceConfiguration>
  RdsDbInstance& WithConfiguration(ConfigurationT&& value) {
    SetConfiguration(std::forward<ConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResourceCostCalculation& GetCostCalculation() const { return m_costCalculation; }
  inline bool CostCalculationHasBeenSet() const { return m_costCalculationHasBeenSet; }
  template <typename CostCalculationT = ResourceCostCalculation>
  void SetCostCalculation(CostCalculationT&& value) {
    m_costCalculationHasBeenSet = true;
    m_costCalculation = std::forward<CostCalculationT>(value);
  }
  template <typename CostCalculationT = ResourceCostCalculation>
  RdsDbInstance& WithCostCalculation(CostCalculationT&& value) {
    SetCostCalculation(std::forward<CostCalculationT>(value));
    return *this;
  }
  ///@}
 private:
  RdsDbInstanceConfiguration m_configuration;

  ResourceCostCalculation m_costCalculation;
  bool m_configurationHasBeenSet = false;
  bool m_costCalculationHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostOptimizationHub
}  // namespace Aws
