/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.net.URI;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.fs.DBFFileSystemProvider;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractFileSystemProvider
implements DBFFileSystemProvider {
    @Override
    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor monitor, @NotNull URI uri, @NotNull DBFVirtualFileSystem[] fileSystems) throws DBException {
        String fsId = DBFUtils.getQueryParameters(uri.getRawQuery()).get("fs");
        return this.getFileSystemByID(monitor, uri, fileSystems, fsId);
    }

    @NotNull
    protected Path getFileSystemByID(@NotNull DBRProgressMonitor monitor, @NotNull URI uri, @NotNull DBFVirtualFileSystem[] fileSystems, @Nullable String fsId) throws DBException {
        DBFVirtualFileSystem fileSystem = null;
        if (CommonUtils.isEmpty((String)fsId)) {
            fileSystem = fileSystems.length == 0 ? null : fileSystems[0];
        } else {
            DBFVirtualFileSystem[] dBFVirtualFileSystemArray = fileSystems;
            int n = fileSystems.length;
            int n2 = 0;
            while (n2 < n) {
                DBFVirtualFileSystem fs = dBFVirtualFileSystemArray[n2];
                if (fs.getId().equals(fsId)) {
                    fileSystem = fs;
                    break;
                }
                ++n2;
            }
        }
        if (fileSystem == null) {
            throw new DBException("Cannot find file system provider for the uri '" + String.valueOf(uri) + "'");
        }
        try {
            return fileSystem.getPathByURI(monitor, uri);
        }
        catch (Throwable e) {
            throw new DBException("Failed to get path from uri '" + String.valueOf(uri) + "': " + e.getMessage(), e);
        }
    }
}

